/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.smeltery.block.BlockTinkerFluid;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockLiquidSlime
extends BlockTinkerFluid {
    public BlockLiquidSlime(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        int oldLevel = (Integer)state.getValue((IProperty)LEVEL);
        super.updateTick(world, pos, state, rand);
        if (oldLevel > 0 && oldLevel == (Integer)state.getValue((IProperty)LEVEL)) {
            Block blockDown;
            if (rand.nextFloat() > 0.6f && (blockDown = world.getBlockState(pos.down()).getBlock()) == Blocks.dirt) {
                for (EnumFacing dir : EnumFacing.HORIZONTALS) {
                    IBlockState state2 = world.getBlockState(pos.offset(dir));
                    if (state2.getBlock() != this || (Integer)state2.getValue((IProperty)LEVEL) != (Integer)state.getValue((IProperty)LEVEL) - 1) continue;
                    IBlockState dirt = world.getBlockState(pos.offset(dir).down());
                    if (dirt.getBlock() == TinkerWorld.slimeDirt) {
                        world.setBlockState(pos.down(), dirt);
                    }
                    if (dirt.getBlock() != TinkerWorld.slimeGrass) continue;
                    world.setBlockState(pos.down(), TinkerWorld.slimeGrass.getDirtState(dirt));
                }
            }
            world.scheduleBlockUpdate(pos, (Block)this, 400 + rand.nextInt(200), 0);
        }
    }

    public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        if (type == EntityLiving.SpawnPlacementType.IN_WATER) {
            return true;
        }
        return super.canCreatureSpawn(world, pos, type);
    }
}

