/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.commons.io.FilenameUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.DummyModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModel;

public class ToolModelLoader
implements ICustomModelLoader {
    public static String EXTENSION = ".tcon";

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.getResourcePath().endsWith(EXTENSION);
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return DummyModel.INSTANCE;
        }
        try {
            Map<String, String> textures = ModelHelper.loadTexturesFromJson(modelLocation);
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList parts = Lists.newArrayList();
            ArrayList brokenParts = Lists.newArrayList();
            for (Map.Entry<String, String> entry : textures.entrySet()) {
                String name = entry.getKey();
                try {
                    ArrayList listToAdd;
                    int i;
                    if (name.startsWith("layer")) {
                        i = Integer.valueOf(name.substring(5));
                        listToAdd = parts;
                    } else if (name.startsWith("broken")) {
                        i = Integer.valueOf(name.substring(6));
                        listToAdd = brokenParts;
                    } else {
                        TinkerRegistry.log.warn("Toolmodel {} has invalid texture entry {}; Skipping layer.", new Object[]{modelLocation, name});
                        continue;
                    }
                    ResourceLocation location = new ResourceLocation(entry.getValue());
                    MaterialModel partModel = new MaterialModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)location));
                    while (listToAdd.size() <= i) {
                        listToAdd.add(null);
                    }
                    listToAdd.set(i, partModel);
                    builder.add((Object)location);
                }
                catch (NumberFormatException e) {
                    TinkerRegistry.log.error("Toolmodel {} has invalid texture entry {}; Skipping layer.", new Object[]{modelLocation, name});
                }
            }
            String toolName = FilenameUtils.getBaseName((String)modelLocation.getResourcePath());
            IModel mods = ModelLoaderRegistry.getModel((ResourceLocation)ModifierModelLoader.getLocationForToolModifiers(toolName));
            ModifierModel modifiers = null;
            if (mods == null || !(mods instanceof ModifierModel)) {
                TinkerRegistry.log.trace("Toolmodel {} does not have any modifiers associated with it. Be sure that the Tools internal name, the Toolmodels filename and the name used inside the Modifier Model Definition match!", new Object[]{modelLocation});
            } else {
                modifiers = (ModifierModel)mods;
            }
            ToolModel output = new ToolModel((ImmutableList<ResourceLocation>)builder.build(), parts, brokenParts, modifiers, ModelHelper.loadTransformFromJson(modelLocation));
            CustomTextureCreator.registerTextures((Collection<ResourceLocation>)builder.build());
            return output;
        }
        catch (IOException e) {
            TinkerRegistry.log.error("Could not load multimodel {}", new Object[]{modelLocation.toString()});
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager) {
    }

    protected ResourceLocation getModelLocation(ResourceLocation p_177580_1_) {
        return new ResourceLocation(p_177580_1_.getResourceDomain(), "models/" + p_177580_1_.getResourcePath() + ".json");
    }
}

