/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.CustomFontColor;

@SideOnly(value=Side.CLIENT)
public class CustomFontRenderer
extends FontRenderer {
    private boolean dropShadow;
    private int state = 0;
    private int red;
    private int green;
    private int blue;

    public CustomFontRenderer(GameSettings gameSettingsIn, ResourceLocation location, TextureManager textureManagerIn) {
        super(gameSettingsIn, location, textureManagerIn, true);
    }

    public List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        return Arrays.asList(this.wrapFormattedStringToWidth(str, wrapWidth).split("\n"));
    }

    protected String wrapFormattedStringToWidth(String str, int wrapWidth) {
        int i = this.sizeStringToWidth(str, wrapWidth);
        if (str.length() <= i) {
            return str;
        }
        String s = str.substring(0, i);
        char c0 = str.charAt(i);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s1 = CustomFontRenderer.getCustomFormatFromString(s) + str.substring(i + (flag ? 1 : 0));
        return s + "\n" + this.wrapFormattedStringToWidth(s1, wrapWidth);
    }

    public static String getCustomFormatFromString(String text) {
        String s = "";
        int j = text.length();
        for (int i = 0; i < j - 1; ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                char c0 = text.charAt(i + 1);
                if (c0 >= '0' && c0 <= '9' || c0 >= 'a' && c0 <= 'f' || c0 >= 'A' && c0 <= 'F') {
                    s = "\u00a7" + c0;
                    ++i;
                    continue;
                }
                if (!(c0 >= 'k' && c0 <= 'o' || c0 >= 'K' && c0 <= 'O' || c0 == 'r') && c0 != 'R') continue;
                s = s + "\u00a7" + c0;
                ++i;
                continue;
            }
            if (c < CustomFontColor.MARKER || c > CustomFontColor.MARKER + 255) continue;
            s = String.format("%s%s%s", Character.valueOf(c), Character.valueOf(text.charAt(i + 1)), Character.valueOf(text.charAt(i + 2)));
            i += 2;
        }
        return s;
    }

    public int renderString(String text, float x, float y, int color, boolean dropShadow) {
        this.dropShadow = dropShadow;
        return super.renderString(text, x, y, color, dropShadow);
    }

    protected float renderUnicodeChar(char letter, boolean italic) {
        if (letter >= CustomFontColor.MARKER && letter <= CustomFontColor.MARKER + 255) {
            int value = letter & 0xFF;
            switch (this.state) {
                case 0: {
                    this.red = value;
                    break;
                }
                case 1: {
                    this.green = value;
                    break;
                }
                case 2: {
                    this.blue = value;
                    break;
                }
                default: {
                    this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    return 0.0f;
                }
            }
            ++this.state;
            this.state %= 3;
            int color = this.red << 16 | this.green << 8 | this.blue | 0xFF000000;
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            if (this.dropShadow) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
            return 0.0f;
        }
        if (this.state != 0) {
            this.state = 0;
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        return super.renderUnicodeChar(letter, italic);
    }

    public void onResourceManagerReload(IResourceManager resourceManager) {
        super.onResourceManagerReload(resourceManager);
        this.setUnicodeFlag(Minecraft.getMinecraft().getLanguageManager().isCurrentLocaleUnicode() || Minecraft.getMinecraft().gameSettings.forceUnicodeFont);
        this.setBidiFlag(Minecraft.getMinecraft().getLanguageManager().isCurrentLanguageBidirectional());
    }
}

