/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.Util;

public abstract class TinkerPulse {
    protected static boolean isToolsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerTools");
    }

    protected static boolean isSmelteryLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
    }

    protected static boolean isWorldLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerWorld");
    }

    protected static <T extends Item> T registerItem(T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.setUnlocalizedName(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        GameRegistry.registerItem(item, (String)name);
        return item;
    }

    protected static <T extends Block> T registerBlock(T block, String name) {
        block.setUnlocalizedName(Util.prefix(name));
        block.setRegistryName(Util.getResource(name));
        GameRegistry.registerBlock(block, (String)Util.resource(name));
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumBlock(T block, String name) {
        TinkerPulse.registerBlock(block, ItemBlockMeta.class, name, new Object[0]);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Block> T registerBlock(T block, Class<? extends ItemBlock> itemBlockClazz, String name, Object ... itemCtorArgs) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        block.setUnlocalizedName(Util.prefix(name));
        block.setRegistryName(Util.getResource(name));
        GameRegistry.registerBlock(block, itemBlockClazz, (String)name, (Object[])itemCtorArgs);
        return block;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }
}

