/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetHandlerPlayServer;
import slimeknights.mantle.network.AbstractPacketThreadsafe;

public class EntityMovementChangePacket
extends AbstractPacketThreadsafe {
    public int entityID;
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;

    public EntityMovementChangePacket() {
    }

    public EntityMovementChangePacket(Entity entity) {
        this.entityID = entity.getEntityId();
        this.x = entity.motionX;
        this.y = entity.motionY;
        this.z = entity.motionZ;
        this.yaw = entity.rotationYaw;
        this.pitch = entity.rotationPitch;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        Entity entity = Minecraft.getMinecraft().theWorld.getEntityByID(this.entityID);
        if (entity != null) {
            entity.motionX = this.x;
            entity.motionY = this.y;
            entity.motionZ = this.z;
            entity.rotationYaw = this.yaw;
            entity.rotationPitch = this.pitch;
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Serverside only");
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
    }
}

