/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.tileentity.TileInventory;

public abstract class TileHeatingStructure
extends TileInventory {
    private static final int TIME_FACTOR = 8;
    protected int fuel;
    protected int temperature;
    protected boolean needsFuel;
    protected int[] itemTemperatures = new int[0];
    protected int[] itemTempRequired = new int[0];

    public TileHeatingStructure(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
    }

    public void resize(int size) {
        super.resize(size);
        this.itemTemperatures = Arrays.copyOf(this.itemTemperatures, size);
        this.itemTempRequired = Arrays.copyOf(this.itemTempRequired, size);
    }

    public boolean canHeat(int index) {
        return this.temperature >= this.getHeatRequiredForSlot(index);
    }

    public float getProgress(int index) {
        if (index >= this.itemTemperatures.length) {
            return 0.0f;
        }
        return (float)this.itemTemperatures[index] / (float)this.itemTempRequired[index];
    }

    protected void setHeatRequiredForSlot(int index, int heat) {
        if (index < this.itemTempRequired.length) {
            this.itemTempRequired[index] = heat * 8;
        }
    }

    protected int getHeatRequiredForSlot(int index) {
        if (index >= this.itemTempRequired.length) {
            return 0;
        }
        return this.itemTempRequired[index] / 8;
    }

    protected abstract void updateHeatRequired(int var1);

    protected void heatItems() {
        boolean heatedItem = false;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack != null) {
                if (this.itemTempRequired[i] <= 0) continue;
                if (this.hasFuel()) {
                    if (this.itemTemperatures[i] >= this.itemTempRequired[i]) {
                        if (!this.onItemFinishedHeating(stack, i)) continue;
                        this.itemTemperatures[i] = 0;
                        this.itemTempRequired[i] = 0;
                        continue;
                    }
                    int n = i;
                    this.itemTemperatures[n] = this.itemTemperatures[n] + this.heatSlot(i);
                    heatedItem = true;
                    continue;
                }
                this.needsFuel = true;
                return;
            }
            this.itemTemperatures[i] = 0;
        }
        if (heatedItem) {
            --this.fuel;
        }
    }

    protected int heatSlot(int i) {
        return this.temperature / 100;
    }

    public int getTemperature(int i) {
        if (i < 0 || i >= this.itemTemperatures.length) {
            return 0;
        }
        return this.itemTemperatures[i];
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (itemstack == null || this.getStackInSlot(slot) != null && !ItemStack.areItemStacksEqual((ItemStack)itemstack, (ItemStack)this.getStackInSlot(slot))) {
            this.itemTemperatures[slot] = 0;
        }
        super.setInventorySlotContents(slot, itemstack);
        this.updateHeatRequired(slot);
    }

    protected abstract boolean onItemFinishedHeating(ItemStack var1, int var2);

    protected abstract void consumeFuel();

    protected void addFuel(int fuel, int newTemperature) {
        this.fuel += fuel;
        this.needsFuel = false;
        this.temperature = newTemperature;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTemperatureFromPacket(int temperature) {
        this.temperature = temperature;
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setInteger("fuel", this.fuel);
        tags.setInteger("temperature", this.temperature);
        tags.setBoolean("needsFuel", this.needsFuel);
        tags.setIntArray("itemTemperatures", this.itemTemperatures);
        tags.setIntArray("itemTempRequired", this.itemTempRequired);
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.fuel = tags.getInteger("fuel");
        this.temperature = tags.getInteger("temperature");
        this.needsFuel = tags.getBoolean("needsFuel");
        this.itemTemperatures = tags.getIntArray("itemTemperatures");
        this.itemTempRequired = tags.getIntArray("itemTempRequired");
    }
}

