/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class TileDrain
extends TileSmelteryComponent
implements IFluidHandler,
IFluidTank {
    public FluidStack getFluid() {
        TileSmeltery smeltery = this.getSmeltery();
        if (smeltery != null && smeltery.getTank().getFluids().size() > 0) {
            return smeltery.getTank().getFluids().get(0);
        }
        return null;
    }

    public int getFluidAmount() {
        FluidStack fs = this.getFluid();
        return fs != null ? fs.amount : 0;
    }

    public int getCapacity() {
        TileSmeltery smeltery = this.getSmeltery();
        if (smeltery != null) {
            return smeltery.getTank().getMaxCapacity() - smeltery.getTank().getUsedCapacity() + this.getFluidAmount();
        }
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    public int fill(FluidStack resource, boolean doFill) {
        TileSmeltery smeltery = this.getSmeltery();
        if (smeltery != null) {
            return smeltery.getTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        TileSmeltery smeltery = this.getSmeltery();
        if (smeltery != null) {
            return smeltery.getTank().drain(maxDrain, doDrain);
        }
        return null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || this.getFluid() == null) {
            return null;
        }
        if (this.getFluid().isFluidEqual(resource)) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.getCapacity() - this.getFluidAmount() > 0;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.getFluid() != null && this.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.getInfo()};
    }
}

