/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL14;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.tileentity.TileCasting;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;

public class CastingRenderer<T extends TileCasting>
extends TileEntitySpecialRenderer<T> {
    protected final float yMin;
    protected final float yMax;
    protected final float xzMin;
    protected final float xzMax;
    protected float yScale;
    protected float xzScale;
    protected float yOffset;
    protected float xzOffset;

    public CastingRenderer(float yMin, float yMax, float xzMin, float xzMax) {
        float s = 0.9995f;
        this.yMin = yMin * s;
        this.yMax = yMax * s;
        this.xzMin = xzMin * s;
        this.xzMax = xzMax * s;
        this.yOffset = yMin + (yMax - yMin) / 2.0f;
        this.xzOffset = xzMin + (xzMax - xzMin) / 2.0f;
        this.yScale = this.xzScale = this.xzMax - this.xzMin;
    }

    public void renderTileEntityAt(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (((TileCasting)((Object)te)).tank.getFluidAmount() == 0 || ((TileCasting)((Object)te)).tank.getCapacity() == 0) {
            return;
        }
        float height = ((float)((TileCasting)((Object)te)).tank.getFluidAmount() - ((TileCasting)((Object)te)).renderOffset) / (float)((TileCasting)((Object)te)).tank.getCapacity();
        ((TileCasting)((Object)te)).renderOffset = ((TileCasting)((Object)te)).renderOffset > 1.2f || ((TileCasting)((Object)te)).renderOffset < -1.2f ? (((TileCasting)((Object)te)).renderOffset -= (((TileCasting)((Object)te)).renderOffset / 12.0f + 0.1f) * partialTicks) : 0.0f;
        float yh = this.yMin + (this.yMax - this.yMin) * height;
        FluidStack fluid = ((TileCasting)((Object)te)).tank.getFluid();
        float progress = 0.0f;
        progress = ((TileCasting)((Object)te)).getCooldownProgress();
        int color = fluid.getFluid().getColor(fluid);
        int a = RenderUtil.alpha(color);
        int r = RenderUtil.red(color);
        int g = RenderUtil.green(color);
        int b = RenderUtil.blue(color);
        r = (int)((float)r * (1.0f - progress));
        g = (int)((float)g * (1.0f - progress));
        b = (int)((float)b * (1.0f - progress));
        color = RenderUtil.compose(r, g, b, a);
        RenderUtil.renderFluidCuboid(((TileCasting)((Object)te)).tank.getFluid(), te.getPos(), x, y, z, this.xzMin, this.yMin, this.xzMin, this.xzMax, yh, this.xzMax, color);
        ItemStack stack = ((TileCasting)((Object)te)).getCurrentResult();
        if (progress > 0.0f && stack != null && te.getStackInSlot(1) == null) {
            RenderUtil.pre(x, y, z);
            int brightness = te.getWorld().getCombinedLight(te.getPos(), 0);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)(brightness % 65536) / 1.0f), (float)((float)(brightness / 65536) / 1.0f));
            GlStateManager.translate((float)this.xzOffset, (float)this.yOffset, (float)this.xzOffset);
            GlStateManager.scale((float)this.xzScale, (float)this.yScale, (float)this.xzScale);
            GlStateManager.scale((float)2.0f, (float)2.0f, (float)2.0f);
            GlStateManager.rotate((float)(-90 * ((TileTable)((Object)te)).getFacing().getHorizontalIndex()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotate((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.blendFunc((int)32771, (int)770);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)progress);
            IBakedModel model = Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getItemModel(stack);
            Minecraft.getMinecraft().getRenderItem().renderItem(stack, model);
            GlStateManager.blendFunc((int)770, (int)771);
            RenderUtil.post();
        }
    }

    public static class Basin
    extends CastingRenderer<TileCastingBasin> {
        public Basin() {
            super(0.25f, 1.0f, 0.125f, 0.875f);
        }
    }

    public static class Table
    extends CastingRenderer<TileCastingTable> {
        public Table() {
            super(0.9375f, 1.001f, 0.0625f, 0.9375f);
            this.xzScale = 0.875f;
            this.yScale = 1.0f;
            this.yOffset += 0.001f;
        }
    }
}

