/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;

public class BlockFaucet
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing input) {
            return input != EnumFacing.DOWN;
        }
    });

    public BlockFaucet() {
        super(Material.rock);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabSmeltery);
        this.setHardness(3.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeMetal);
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing face;
        if (meta >= EnumFacing.values().length) {
            meta = 1;
        }
        if ((face = EnumFacing.values()[meta]) == EnumFacing.DOWN) {
            face = EnumFacing.UP;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)face);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).ordinal();
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.isSneaking()) {
            return false;
        }
        TileEntity te = worldIn.getTileEntity(pos);
        if (te instanceof TileFaucet) {
            ((TileFaucet)te).activate();
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (worldIn.isRemote) {
            return;
        }
        TileEntity te = worldIn.getTileEntity(pos);
        if (te instanceof TileFaucet) {
            ((TileFaucet)te).handleRedstone(worldIn.isBlockPowered(pos));
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)worldIn.getBlockState(pos).getValue((IProperty)FACING);
        float xMin = 0.25f;
        float xMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.625f;
        switch (facing) {
            case UP: {
                yMin = 0.625f;
                yMax = 1.0f;
                break;
            }
            case SOUTH: {
                zMin = 0.625f;
                zMax = 1.0f;
                break;
            }
            case NORTH: {
                zMax = 0.375f;
                zMin = 0.0f;
                break;
            }
            case EAST: {
                xMin = 0.625f;
                xMax = 1.0f;
                break;
            }
            case WEST: {
                xMax = 0.375f;
                xMin = 0.0f;
            }
        }
        this.setBlockBounds(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public AxisAlignedBB getCollisionBoundingBox(World worldIn, BlockPos pos, IBlockState state) {
        float xMin = 0.25f;
        float xMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.625f;
        switch ((EnumFacing)state.getValue((IProperty)FACING)) {
            case UP: {
                yMin = 0.625f;
                yMax = 1.0f;
                break;
            }
            case SOUTH: {
                zMin = 0.625f;
                zMax = 1.0f;
                break;
            }
            case NORTH: {
                zMax = 0.375f;
                zMin = 0.0f;
                break;
            }
            case EAST: {
                xMin = 0.625f;
                xMax = 1.0f;
                break;
            }
            case WEST: {
                xMax = 0.375f;
                xMin = 0.0f;
            }
        }
        return AxisAlignedBB.fromBounds((double)((float)pos.getX() + xMin), (double)((float)pos.getY() + yMin), (double)((float)pos.getZ() + zMin), (double)((float)pos.getX() + xMax), (double)((float)pos.getY() + yMax), (double)((float)pos.getZ() + zMax));
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isFullCube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileFaucet();
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.getOpposite();
        if (enumfacing == EnumFacing.DOWN) {
            enumfacing = placer.getHorizontalFacing().getOpposite();
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }
}

