/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class HarvestLevels {
    public static final int STONE = 0;
    public static final int IRON = 1;
    public static final int DIAMOND = 2;
    public static final int OBSIDIAN = 3;
    public static final int COBALT = 4;
    public static final Map<Integer, String> harvestLevelNames = Maps.newHashMap();

    private HarvestLevels() {
    }

    public static String getHarvestLevelName(int num) {
        return harvestLevelNames.containsKey(num) ? harvestLevelNames.get(num) : String.valueOf(num);
    }

    public static void init() {
        harvestLevelNames.put(0, TinkerMaterials.stone.getTextColor() + Util.translate("ui.mininglevel.stone", new Object[0]));
        harvestLevelNames.put(1, TinkerMaterials.iron.getTextColor() + Util.translate("ui.mininglevel.iron", new Object[0]));
        harvestLevelNames.put(2, EnumChatFormatting.AQUA + Util.translate("ui.mininglevel.diamond", new Object[0]));
        harvestLevelNames.put(3, TinkerMaterials.obsidian.getTextColor() + Util.translate("ui.mininglevel.obsidian", new Object[0]));
        harvestLevelNames.put(4, TinkerMaterials.cobalt.getTextColor() + Util.translate("ui.mininglevel.cobalt", new Object[0]));
    }

    static {
        String base = "gui.mining";
        int i = 0;
        while (StatCollector.canTranslate((String)String.format("%s%d", base, i + 1))) {
            harvestLevelNames.put(i, StatCollector.translateToLocal((String)String.format("%s%d", base, i + 1)));
            ++i;
        }
    }
}

