/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static MovingObjectPosition raytraceEntityPlayerLook(EntityPlayer player, float range) {
        Vec3 eye = new Vec3(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ);
        Vec3 look = player.getLook(1.0f);
        return EntityUtil.raytraceEntity((Entity)player, eye, look, range, true);
    }

    public static MovingObjectPosition raytraceEntity(Entity entity, Vec3 start, Vec3 look, double range, boolean ignoreCanBeCollidedWith) {
        Vec3 direction = start.addVector(look.xCoord * range, look.yCoord * range, look.zCoord * range);
        Entity pointedEntity = null;
        Vec3 hit = null;
        AxisAlignedBB bb = entity.getEntityBoundingBox().addCoord(look.xCoord * range, look.yCoord * range, look.zCoord * range).expand(1.0, 1.0, 1.0);
        List entitiesInArea = entity.worldObj.getEntitiesWithinAABBExcludingEntity(entity, bb);
        double range2 = range;
        for (Entity candidate : entitiesInArea) {
            double dist;
            if (!ignoreCanBeCollidedWith && !candidate.canBeCollidedWith()) continue;
            double colBorder = candidate.getCollisionBorderSize();
            AxisAlignedBB entityBB = candidate.getEntityBoundingBox().expand(colBorder, colBorder, colBorder);
            MovingObjectPosition movingobjectposition = entityBB.calculateIntercept(start, direction);
            if (entityBB.isVecInside(start)) {
                if (!(0.0 < range2) && range2 != 0.0) continue;
                pointedEntity = candidate;
                hit = movingobjectposition == null ? start : movingobjectposition.hitVec;
                range2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((dist = start.distanceTo(movingobjectposition.hitVec)) < range2) && range2 != 0.0) continue;
            if (candidate == entity.ridingEntity && !entity.canRiderInteract()) {
                if (range2 != 0.0) continue;
                pointedEntity = candidate;
                hit = movingobjectposition.hitVec;
                continue;
            }
            pointedEntity = candidate;
            hit = movingobjectposition.hitVec;
            range2 = dist;
        }
        if (pointedEntity != null && range2 < range) {
            return new MovingObjectPosition(pointedEntity, hit);
        }
        return null;
    }
}

