/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.traits;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class AbstractTraitLeveled
extends AbstractTrait {
    protected final String name;
    protected final int levels;

    public AbstractTraitLeveled(String identifier, int color, int maxLevels, int levels) {
        this(identifier, String.valueOf(levels), color, maxLevels, levels);
    }

    public AbstractTraitLeveled(String identifier, String suffix, int color, int maxLevels, int levels) {
        super(identifier + suffix, color);
        this.name = identifier;
        this.levels = levels;
        IModifier modifier = TinkerRegistry.getModifier(this.name);
        if (modifier != null) {
            if (modifier instanceof AbstractTraitLeveled && ((AbstractTraitLeveled)modifier).levels > this.levels) {
                TinkerRegistry.registerModifierAlias(this, this.name);
            }
        } else {
            TinkerRegistry.registerModifierAlias(this, this.name);
        }
        this.aspects.clear();
        this.addAspects(new ModifierAspect.LevelAspect(this, maxLevels), new ModifierAspect.DataAspect((IModifier)this, color));
    }

    @Override
    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        super.updateNBTforTrait(modifierTag, newColor);
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        data.level = 0;
        data.write(modifierTag);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
        int index = TinkerUtil.getIndexInCompoundList(tagList, this.getModifierIdentifier());
        NBTTagCompound tag = new NBTTagCompound();
        if (index > -1) {
            tag = tagList.getCompoundTagAt(index);
        } else {
            index = tagList.tagCount();
            tagList.appendTag((NBTBase)tag);
        }
        if (!tag.getBoolean(this.identifier)) {
            ModifierNBT data = ModifierNBT.readTag(tag);
            data.level += this.levels;
            data.write(tag);
            tag.setBoolean(this.identifier, true);
            tagList.set(index, (NBTBase)tag);
            TagUtil.setModifiersTagList(rootCompound, tagList);
            this.applyModifierEffect(rootCompound);
        }
    }

    public void applyModifierEffect(NBTTagCompound rootCompound) {
    }

    @Override
    public String getModifierIdentifier() {
        return this.name;
    }

    @Override
    public String getLocalizedName() {
        String locName = Util.translate("modifier.%s.name", this.name);
        if (this.levels > 1) {
            locName = locName + " " + TinkerUtil.getRomanNumeral(this.levels);
        }
        return locName;
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translate("modifier.%s.desc", this.name);
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

