/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.registry.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.library.TinkerRegistry;

public class Util {
    public static final String MODID = "tconstruct";
    public static final String RESOURCE = "tconstruct".toLowerCase(Locale.US);

    public static Logger getLogger(String type) {
        String log = MODID;
        return LogManager.getLogger((String)(log + "-" + type));
    }

    public static String sanitizeLocalizationString(String string) {
        return string.toLowerCase(Locale.US).replaceAll(" ", "");
    }

    public static String resource(String res) {
        return String.format("%s:%s", RESOURCE, res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation(RESOURCE, res);
    }

    public static ModelResourceLocation getModelResource(String res, String variant) {
        return new ModelResourceLocation(Util.resource(res), variant);
    }

    public static String prefix(String name) {
        return String.format("%s.%s", RESOURCE, name.toLowerCase(Locale.US));
    }

    public static String translate(String key, Object ... pars) {
        return StatCollector.translateToLocal((String)StatCollector.translateToLocal((String)String.format(key, pars)).trim()).trim();
    }

    public static String translateFormatted(String key, Object ... pars) {
        return StatCollector.translateToLocal((String)StatCollector.translateToLocalFormatted((String)key, (Object[])pars).trim()).trim();
    }

    public static List<String> getTooltips(String text) {
        int k;
        LinkedList list = Lists.newLinkedList();
        if (text == null) {
            return list;
        }
        int j = 0;
        while ((k = text.indexOf("\\n", j)) >= 0) {
            list.add(text.substring(j, k));
            j = k + 2;
        }
        list.add(text.substring(j, text.length()));
        return list;
    }

    public static String convertNewlines(String line) {
        int j;
        if (line == null) {
            return null;
        }
        while ((j = line.indexOf("\\n")) >= 0) {
            line = line.substring(0, j) + '\n' + line.substring(j + 2);
        }
        return line;
    }

    public static ResourceLocation getItemLocation(Item item) {
        ResourceLocation o = GameData.getItemRegistry().getNameForObject((Object)item);
        if (o == null) {
            TinkerRegistry.log.error("Item %s is not registered!" + item.getUnlocalizedName());
            return null;
        }
        return o;
    }

    public static ItemStack[] copyItemStackArray(ItemStack[] in) {
        return RecipeMatchRegistry.copyItemStackArray((ItemStack[])in);
    }

    public static boolean isCtrlKeyDown() {
        boolean isCtrlKeyDown;
        boolean bl = isCtrlKeyDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (!isCtrlKeyDown && Minecraft.isRunningOnMac) {
            isCtrlKeyDown = Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return isCtrlKeyDown;
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static int enumChatFormattingToColor(EnumChatFormatting color) {
        int i = color.getColorIndex();
        int j = (i >> 3 & 1) * 85;
        int k = (i >> 2 & 1) * 170 + j;
        int l = (i >> 1 & 1) * 170 + j;
        int i1 = (i >> 0 & 1) * 170 + j;
        if (i == 6) {
            k += 85;
        }
        if (i >= 16) {
            k /= 4;
            l /= 4;
            i1 /= 4;
        }
        return (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
    }
}

