/*
 * Decompiled with CFR 0.152.
 */
package fuj1n.recmod;

import fuj1n.recmod.client.event.EventClientEntityLogin;
import fuj1n.recmod.client.event.EventClientTick;
import fuj1n.recmod.client.event.EventRenderGame;
import fuj1n.recmod.command.CommandRec;
import fuj1n.recmod.network.GuiHandler;
import fuj1n.recmod.network.PlayerTracker;
import fuj1n.recmod.network.packet.PacketClientCommand;
import fuj1n.recmod.network.packet.PacketEndOfInitialTransmission;
import fuj1n.recmod.network.packet.PacketPipeline;
import fuj1n.recmod.network.packet.PacketRemovePlayer;
import fuj1n.recmod.network.packet.PacketUpdatePlayerStatus;
import java.io.File;
import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(name="Recording Status Mod", version="v1.5.2.2", modid="fuj1n.recmod", acceptableRemoteVersions="*")
public class RecMod {
    @Mod.Instance(value="fuj1n.recmod")
    public static RecMod instance;
    public static final PacketPipeline packetPipeline;
    private static HashMap<String, Boolean> recorders;
    private static HashMap<String, Boolean> streamers;
    public boolean showSelf = true;
    public boolean keepState = false;
    public boolean recState = false;
    public boolean strState = false;
    public boolean enableKeys = false;
    public int keyRec = 44;
    public int keyStr = 45;
    public int showMode = 3;
    public int posMode = 1;
    public int absX = 0;
    public int absY = 0;
    private File configFile;
    private Configuration config;
    public boolean mapsDirty = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (event.getSide() == Side.CLIENT) {
            this.configFile = event.getSuggestedConfigurationFile();
            this.instantiateConfig();
            this.readFromFile();
            MinecraftForge.EVENT_BUS.register((Object)new EventRenderGame());
            MinecraftForge.EVENT_BUS.register((Object)new EventClientEntityLogin());
            MinecraftForge.EVENT_BUS.register((Object)new EventClientTick());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline.initialise();
        PacketPipeline pp = packetPipeline;
        pp.registerPacket(PacketUpdatePlayerStatus.class);
        pp.registerPacket(PacketRemovePlayer.class);
        pp.registerPacket(PacketClientCommand.class);
        pp.registerPacket(PacketEndOfInitialTransmission.class);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        this.clearMaps();
        ServerCommandManager handler = (ServerCommandManager)FMLCommonHandler.instance().getMinecraftServerInstance().getCommandManager();
        handler.registerCommand((ICommand)new CommandRec());
    }

    public void updatePlayerInformation(String username, int type, boolean flag) {
        HashMap<String, Boolean> modifyMap = type == 0 ? recorders : streamers;
        modifyMap.put(username, flag);
    }

    public boolean isPlayerRecording(String username) {
        return username != null && recorders.getOrDefault(username, false) != false;
    }

    public boolean isPlayerStreaming(String username) {
        return username != null && streamers.getOrDefault(username, false) != false;
    }

    @SideOnly(value=Side.CLIENT)
    public void instantiateConfig() {
        this.config = new Configuration(this.configFile, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void readFromFile() {
        this.config.load();
        this.showMode = this.config.getInt("Bobber AutoShow Mode", "Interface", this.showMode, 0, 3, "The automatic behaviour of the ingame bobber visibility.");
        this.posMode = this.config.getInt("Bobber Position Mode", "Interface", this.posMode, 0, 5, "The positioning mode of the bobber.");
        this.absX = this.config.getInt("Bobber Position Absolute X", "Interface", this.absX, -4096, 4096, "The absolute X position of the bobber. (only for absolute position mode)");
        this.absY = this.config.getInt("Bobber Position Absolute Y", "Interface", this.absY, -2160, 2160, "The absolute Y position of the bobber. (only for absolute position mode)");
        this.enableKeys = this.config.getBoolean("Enable keyboard", "Keyboard", this.enableKeys, "Whether the keyboard shortcuts are enabled.");
        this.keyRec = this.config.getInt("Record Key", "Keyboard", this.keyRec, -1338, 250, "The key that will toggle recording.");
        this.keyStr = this.config.getInt("Stream Key", "Keyboard", this.keyStr, -1338, 250, "The key that will toggle streaming.");
        this.keepState = this.config.getBoolean("Keep state", "General", this.keepState, "Whether the recording state is kept throughout the gaming session.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void writeToFile() {
        this.configFile.delete();
        this.readFromFile();
    }

    public void removeUnneededData(String username) {
        recorders.remove(username);
        streamers.remove(username);
    }

    public void clearMaps() {
        recorders.clear();
        streamers.clear();
    }

    public void sendDataToPlayer(EntityPlayer player) {
        int i;
        for (i = 0; i < recorders.size(); ++i) {
            this.sendPacket(player, recorders.keySet().toArray()[i].toString(), 0, Boolean.parseBoolean(recorders.values().toArray()[i].toString()));
        }
        for (i = 0; i < streamers.size(); ++i) {
            this.sendPacket(player, streamers.keySet().toArray()[i].toString(), 1, Boolean.parseBoolean(streamers.values().toArray()[i].toString()));
        }
        if (player instanceof EntityPlayerMP) {
            PacketEndOfInitialTransmission pckt = new PacketEndOfInitialTransmission();
            packetPipeline.sendTo(pckt, (EntityPlayerMP)player);
        }
    }

    public void sendPacket(EntityPlayer target, String player, int type, boolean flag) {
        if (target instanceof EntityPlayerMP) {
            PacketUpdatePlayerStatus pckt = new PacketUpdatePlayerStatus(player, type, flag);
            packetPipeline.sendTo(pckt, (EntityPlayerMP)target);
        }
    }

    static {
        packetPipeline = new PacketPipeline();
        recorders = new HashMap();
        streamers = new HashMap();
    }
}

