/*
 * Decompiled with CFR 0.152.
 */
package fuj1n.recmod.client.event;

import com.mojang.authlib.GameProfile;
import fuj1n.recmod.RecMod;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventRenderGame
extends Gui {
    private static final int INDICATOR_WIDTH = 8;
    private static final int INDICATOR_PADDING = 0;
    private static final int INDICATOR_TOTAL = 16;
    private ResourceLocation indicatorsHigh = new ResourceLocation("recmod:textures/sheets/indicatorsx2.png");
    private ResourceLocation indicatorsLow = new ResourceLocation("recmod:textures/sheets/indicators.png");
    private GuiPlayerTabOverlay to;

    @SubscribeEvent
    public void preRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        ResourceLocation indicators;
        Minecraft mc = Minecraft.getMinecraft();
        ResourceLocation resourceLocation = indicators = Minecraft.isFancyGraphicsEnabled() ? this.indicatorsHigh : this.indicatorsLow;
        if (event.type == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
            this.to = mc.ingameGUI.getTabList();
            this.renderPlayerList(event, mc, indicators);
        }
    }

    public void renderPlayerList(RenderGameOverlayEvent.Pre event, Minecraft mc, ResourceLocation indicators) {
        boolean flag;
        int l3;
        int width = event.resolution.getScaledWidth();
        Scoreboard scoreboardIn = mc.theWorld.getScoreboard();
        ScoreObjective scoreObjectiveIn = scoreboardIn.getObjectiveInDisplaySlot(0);
        NetHandlerPlayClient nethandlerplayclient = mc.thePlayer.sendQueue;
        List list = GuiPlayerTabOverlay.ENTRY_ORDERING.sortedCopy((Iterable)nethandlerplayclient.getPlayerInfoMap());
        int namePingGap = 0;
        int j = 0;
        for (NetworkPlayerInfo networkplayerinfo : list) {
            int nameWidth = mc.fontRendererObj.getStringWidth(this.to.getPlayerName(networkplayerinfo));
            namePingGap = Math.max(namePingGap, nameWidth);
            if (scoreObjectiveIn == null || scoreObjectiveIn.getRenderType() == IScoreCriteria.EnumRenderType.HEARTS) continue;
            nameWidth = mc.fontRendererObj.getStringWidth(" " + scoreboardIn.getOrCreateScore(networkplayerinfo.getGameProfile().getName(), scoreObjectiveIn).getScorePoints());
            j = Math.max(j, nameWidth);
        }
        list = list.subList(0, Math.min(list.size(), 80));
        int i4 = l3 = list.size();
        int userRows = 1;
        while (i4 > 20) {
            i4 = (l3 + ++userRows - 1) / userRows;
        }
        boolean bl = flag = mc.isIntegratedServerRunning() || mc.getNetHandler().getNetworkManager().getIsencrypted();
        int l = scoreObjectiveIn != null ? (scoreObjectiveIn.getRenderType() == IScoreCriteria.EnumRenderType.HEARTS ? 90 : j) : 0;
        int userWidth = Math.min(userRows * ((flag ? 9 : 0) + namePingGap + l + 13), width - 50) / userRows;
        int userX = width / 2 - (userWidth * userRows + (userRows - 1) * 5) / 2;
        int menuY = 10;
        int menuWidth = userWidth * userRows + (userRows - 1) * 5;
        List list1 = null;
        List list2 = null;
        if (this.to.header != null) {
            list1 = mc.fontRendererObj.listFormattedStringToWidth(this.to.header.getFormattedText(), width - 50);
            for (String s : list1) {
                menuWidth = Math.max(menuWidth, mc.fontRendererObj.getStringWidth(s));
            }
        }
        if (this.to.footer != null) {
            list2 = mc.fontRendererObj.listFormattedStringToWidth(this.to.footer.getFormattedText(), width - 50);
            for (String s2 : list2) {
                menuWidth = Math.max(menuWidth, mc.fontRendererObj.getStringWidth(s2));
            }
        }
        userWidth += 16;
        userX -= 16 * userRows / 2;
        menuWidth += 16 * userRows;
        if (list1 != null) {
            EventRenderGame.drawRect((int)(width / 2 - menuWidth / 2 - 1), (int)(menuY - 1), (int)(width / 2 + menuWidth / 2 + 1), (int)(menuY + list1.size() * mc.fontRendererObj.FONT_HEIGHT), (int)Integer.MIN_VALUE);
            for (String s3 : list1) {
                int i2 = mc.fontRendererObj.getStringWidth(s3);
                mc.fontRendererObj.drawStringWithShadow(s3, (float)(width / 2 - i2 / 2), (float)menuY, -1);
                menuY += mc.fontRendererObj.FONT_HEIGHT;
            }
            ++menuY;
        }
        EventRenderGame.drawRect((int)(width / 2 - menuWidth / 2 - 1), (int)(menuY - 1), (int)(width / 2 + menuWidth / 2 + 1), (int)(menuY + i4 * 9), (int)Integer.MIN_VALUE);
        for (int k4 = 0; k4 < l3; ++k4) {
            int k5;
            int l5;
            int indicatorStrIndex;
            int l4 = k4 / i4;
            int i5 = k4 % i4;
            int j2 = userX + l4 * userWidth + l4 * 5;
            int k2 = menuY + i5 * 9;
            EventRenderGame.drawRect((int)j2, (int)k2, (int)(j2 + userWidth), (int)(k2 + 8), (int)0x20FFFFFF);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            if (k4 >= list.size()) continue;
            NetworkPlayerInfo networkplayerinfo1 = (NetworkPlayerInfo)list.get(k4);
            String s1 = this.to.getPlayerName(networkplayerinfo1);
            GameProfile gameprofile = networkplayerinfo1.getGameProfile();
            if (flag) {
                EntityPlayer entityplayer = mc.theWorld.getPlayerEntityByUUID(gameprofile.getId());
                boolean flag1 = entityplayer != null && entityplayer.isWearing(EnumPlayerModelParts.CAPE) && (gameprofile.getName().equals("Dinnerbone") || gameprofile.getName().equals("Grumm"));
                mc.getTextureManager().bindTexture(networkplayerinfo1.getLocationSkin());
                int l2 = 8 + (flag1 ? 8 : 0);
                int i3 = 8 * (flag1 ? -1 : 1);
                Gui.drawScaledCustomSizeModalRect((int)j2, (int)k2, (float)8.0f, (float)l2, (int)8, (int)i3, (int)8, (int)8, (float)64.0f, (float)64.0f);
                if (entityplayer != null && entityplayer.isWearing(EnumPlayerModelParts.HAT)) {
                    int j3 = 8 + (flag1 ? 8 : 0);
                    int k3 = 8 * (flag1 ? -1 : 1);
                    Gui.drawScaledCustomSizeModalRect((int)j2, (int)k2, (float)40.0f, (float)j3, (int)8, (int)k3, (int)8, (int)8, (float)64.0f, (float)64.0f);
                }
                j2 += 9;
            }
            if (networkplayerinfo1.getGameType() == WorldSettings.GameType.SPECTATOR) {
                s1 = TextFormatting.ITALIC + s1;
                mc.fontRendererObj.drawStringWithShadow(s1, (float)j2, (float)k2, -1862270977);
            } else {
                mc.fontRendererObj.drawStringWithShadow(s1, (float)j2, (float)k2, -1);
            }
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.getTextureManager().bindTexture(indicators);
            int indicatorRecIndex = RecMod.instance.isPlayerRecording(networkplayerinfo1.getGameProfile().getName()) ? 1 : 0;
            int n = indicatorStrIndex = RecMod.instance.isPlayerStreaming(networkplayerinfo1.getGameProfile().getName()) ? 2 : 0;
            if (indicatorRecIndex != 3) {
                this.drawTexturedModalRect(j2 - (flag ? 9 : 0) + userWidth - 16 + 0, k2, indicatorRecIndex * 8, (int)Math.floor(indicatorRecIndex / 32) * 8 + 0, 8, 8);
            }
            this.drawTexturedModalRect(j2 - (flag ? 9 : 0) + userWidth - 16 + 0 + 8, k2, indicatorStrIndex * 8, (int)Math.floor(indicatorStrIndex / 32) * 8 + 0, 8, 8);
            if (scoreObjectiveIn != null && networkplayerinfo1.getGameType() != WorldSettings.GameType.SPECTATOR && (l5 = (k5 = j2 + namePingGap + 1) + l) - k5 > 5) {
                this.to.drawScoreboardValues(scoreObjectiveIn, k2, gameprofile.getName(), k5, l5, networkplayerinfo1);
            }
            this.to.drawPing(userWidth - 16, j2 - (flag ? 9 : 0), k2, networkplayerinfo1);
        }
        if (list2 != null) {
            menuY = menuY + i4 * 9 + 1;
            EventRenderGame.drawRect((int)(width / 2 - menuWidth / 2 - 1), (int)(menuY - 1), (int)(width / 2 + menuWidth / 2 + 1), (int)(menuY + list2.size() * mc.fontRendererObj.FONT_HEIGHT), (int)Integer.MIN_VALUE);
            for (String s4 : list2) {
                int j5 = mc.fontRendererObj.getStringWidth(s4);
                mc.fontRendererObj.drawStringWithShadow(s4, (float)(width / 2 - j5 / 2), (float)menuY, -1);
                menuY += mc.fontRendererObj.FONT_HEIGHT;
            }
        }
    }

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        ResourceLocation indicators;
        Minecraft mc = Minecraft.getMinecraft();
        ResourceLocation resourceLocation = indicators = Minecraft.isFancyGraphicsEnabled() ? this.indicatorsHigh : this.indicatorsLow;
        if (event.type == RenderGameOverlayEvent.ElementType.ALL && RecMod.instance.showSelf && mc.currentScreen == null) {
            int y;
            int x;
            switch (RecMod.instance.posMode) {
                case 0: {
                    x = 0;
                    y = 0;
                    break;
                }
                case 1: {
                    x = event.resolution.getScaledWidth() - 32;
                    y = 0;
                    break;
                }
                case 2: {
                    x = event.resolution.getScaledWidth() / 2 - 16;
                    y = event.resolution.getScaledHeight() / 2 - 8;
                    break;
                }
                case 3: {
                    x = 0;
                    y = event.resolution.getScaledHeight() - 16;
                    break;
                }
                case 4: {
                    x = event.resolution.getScaledWidth() - 32;
                    y = event.resolution.getScaledHeight() - 16;
                    break;
                }
                case 5: {
                    x = event.resolution.getScaledWidth() / 2 - 16 + RecMod.instance.absX;
                    y = event.resolution.getScaledHeight() / 2 - 8 + RecMod.instance.absY;
                    break;
                }
                default: {
                    x = event.resolution.getScaledWidth() - 32;
                    y = 0;
                }
            }
            int indicatorRecIndex = RecMod.instance.isPlayerRecording(mc.thePlayer.getName()) ? 1 : 0;
            int indicatorStrIndex = RecMod.instance.isPlayerStreaming(mc.thePlayer.getName()) ? 2 : 0;
            mc.getTextureManager().bindTexture(indicators);
            this.drawTexturedModalRect(x, y, indicatorRecIndex * 16, (int)Math.floor(indicatorRecIndex / 16) * 16 + 80, 16, 16);
            this.drawTexturedModalRect(x + 16, y, indicatorStrIndex * 16, (int)Math.floor(indicatorStrIndex / 16) * 16 + 80, 16, 16);
        }
    }
}

