/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.nether;

import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;

public class FusewoodTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;

    public FusewoodTreeGenerator(int treeHeight, IBlockState log, IBlockState leaves, boolean seekHeight) {
        this.minTreeHeight = treeHeight;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
    }

    public FusewoodTreeGenerator(int treeHeight, IBlockState log, IBlockState leaves) {
        this(treeHeight, log, leaves, true);
    }

    BlockPos findGround(World world, BlockPos pos) {
        boolean foundGround = false;
        int height = pos.func_177956_o();
        BlockPos position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
        do {
            Block underBlock;
            if ((underBlock = world.func_180495_p(position = position.func_177977_b()).func_177230_c()) != Blocks.field_150424_aL && underBlock != Blocks.field_150425_aM && underBlock != NaturaNether.netherTaintedSoil && position.func_177956_o() >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return position.func_177984_a();
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World world, BlockPos pos) {
        int height = random.nextInt(3) + this.minTreeHeight;
        if (height < 4) {
            height = 4;
        }
        if (this.seekHeight && (pos = this.findGround(world, pos)).func_177956_o() < 0) {
            return;
        }
        int yPos = pos.func_177956_o();
        if (yPos >= 1 && yPos + height + 1 <= 256) {
            boolean isSoil;
            if (!this.checkClear(world, pos.func_177958_n(), yPos, pos.func_177956_o(), height)) {
                return;
            }
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            Block soil = state.func_177230_c();
            boolean bl = isSoil = soil != null && soil.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaNether.netherSapling) || soil == Blocks.field_150424_aL;
            if (isSoil && yPos < 256 - height - 1) {
                soil.onPlantGrow(state, world, pos.func_177977_b(), pos);
                this.placeCanopy(world, random, pos, height);
                this.placeTrunk(world, pos, height);
            }
        }
    }

    boolean checkClear(World world, int xPos, int yPos, int zPos, int treeHeight) {
        boolean flag = true;
        for (int y = yPos; y <= yPos + 1 + treeHeight; ++y) {
            int range = 1;
            if (y == yPos) {
                range = 0;
            }
            if (y >= yPos + 1 + treeHeight - 2) {
                range = 2;
            }
            for (int x = xPos - range; x <= xPos + range && flag; ++x) {
                for (int z = zPos - range; z <= zPos + range && flag; ++z) {
                    if (y >= 0 && y < 256) {
                        BlockPos blockpos = new BlockPos(x, y, z);
                        IBlockState state = world.func_180495_p(blockpos);
                        Block block = state.func_177230_c();
                        if (block.isAir(state, (IBlockAccess)world, blockpos) || block.isLeaves(state, (IBlockAccess)world, blockpos) || block == Blocks.field_150424_aL || block == Blocks.field_150425_aM || block == NaturaNether.netherTaintedSoil || block.isWood((IBlockAccess)world, blockpos)) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected void placeCanopy(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int subract = y - (pos.func_177956_o() + height);
            int subract2 = 1 - subract / 2;
            for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state;
                    int mathZ = z - pos.func_177952_p();
                    if (Math.abs(mathX) == subract2 && Math.abs(mathZ) == subract2 && (random.nextInt(2) == 0 || subract == 0) || (state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c() != null && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    world.func_180501_a(blockpos, this.leaves, 2);
                }
            }
        }
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + localHeight, pos.func_177952_p());
            IBlockState state = world.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (!block.isAir(state, (IBlockAccess)world, blockpos) && block != null && !block.isLeaves(state, (IBlockAccess)world, blockpos)) continue;
            world.func_180501_a(blockpos, this.log, 2);
        }
    }
}

