/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.pulsar.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.config.IConfiguration;
import slimeknights.mantle.pulsar.pulse.PulseMeta;

@ParametersAreNonnullByDefault
public class Configuration
implements IConfiguration {
    private static final int CONFIG_LEVEL = 1;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final String confPath;
    private final Logger logger;
    private Map<String, ConfigEntry> modules;

    public Configuration(String confName, Logger logger) {
        this.confPath = Loader.instance().getConfigDir().toString() + File.separator + confName + ".json";
        this.logger = logger;
    }

    @Override
    public void load() {
        this.getModulesFromJson();
    }

    @Override
    public boolean isModuleEnabled(@Nonnull PulseMeta meta) {
        ConfigEntry entry = this.modules.get(meta.getId());
        if (entry == null) {
            this.modules.put(meta.getId(), new ConfigEntry(meta.isDefaultEnabled(), meta.getDescription()));
            return meta.isEnabled();
        }
        return entry.getEnabled();
    }

    @Override
    public void flush() {
        this.writeModulesToJson();
    }

    private void getModulesFromJson() {
        File f = new File(this.confPath);
        if (!f.exists()) {
            this.logger.info("Couldn't find config file; will generate a new one later.");
            this.modules = new HashMap<String, ConfigEntry>();
            return;
        }
        if (!f.canRead() || !f.canWrite()) {
            throw new FileNotReadWritableException("Could not read/write Pulsar config: " + this.confPath);
        }
        try {
            try {
                this.modules = this.parseV1Config(f);
            }
            catch (Exception ex) {
                this.logger.warn("Failed to parse " + f.getName() + " using the v1 parser; trying the v0 parser.");
                Map<String, ConfigEntry> conf = this.parseV0Config(f);
                this.logger.info("Found valid v0 configuration. Upgrading it.");
                this.modules = conf;
                this.writeModulesToJson();
                this.logger.info("Upgrade complete! Config is now in v1 format.");
            }
        }
        catch (Exception ex) {
            this.logger.warn("Invalid config file. Discarding.");
            ex.printStackTrace();
            this.modules = new HashMap<String, ConfigEntry>();
        }
    }

    private Map<String, ConfigEntry> parseV0Config(File f) throws Exception {
        try {
            JsonReader reader = new JsonReader(new InputStreamReader(new FileInputStream(f)));
            Map m = (Map)gson.fromJson(reader, new TypeToken<HashMap<String, Boolean>>(){}.getType());
            if (m == null) {
                throw new NullPointerException("Gson returned null.");
            }
            HashMap<String, ConfigEntry> out = new HashMap<String, ConfigEntry>();
            for (Map.Entry e : m.entrySet()) {
                out.put((String)e.getKey(), new ConfigEntry((Boolean)e.getValue()));
            }
            return out;
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("This shouldn't be possible... " + fnfe);
        }
    }

    private Map<String, ConfigEntry> parseV1Config(File f) throws Exception {
        try {
            JsonReader reader = new JsonReader(new InputStreamReader(new FileInputStream(f)));
            GsonConfig c = (GsonConfig)gson.fromJson(reader, (Type)((Object)GsonConfig.class));
            if (c.getConfigVersion() > 1) {
                throw new RuntimeException("Pulsar config is from a newer version! Remove it! " + f.getAbsolutePath());
            }
            if (c.getModules() == null) {
                throw new IllegalArgumentException("Not a valid GsonConfig. Try v0 parsing.");
            }
            return c.getModules();
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("This shouldn't be possible... " + fnfe);
        }
    }

    private void writeModulesToJson() {
        try {
            JsonWriter writer = new JsonWriter(new OutputStreamWriter(new FileOutputStream(new File(this.confPath))));
            writer.setIndent("  ");
            GsonConfig out = new GsonConfig(1, this.modules);
            gson.toJson((Object)out, (Type)((Object)GsonConfig.class), writer);
            writer.close();
        }
        catch (Exception ex) {
            this.logger.warn("Could not write config? " + this.confPath);
        }
    }

    private static class GsonConfig {
        private int CONFIG_VERSION = 0;
        private Map<String, ConfigEntry> modules;

        public GsonConfig(int version, Map<String, ConfigEntry> modules) {
            this.CONFIG_VERSION = version;
            this.modules = modules;
        }

        public int getConfigVersion() {
            return this.CONFIG_VERSION;
        }

        public Map<String, ConfigEntry> getModules() {
            return this.modules;
        }
    }

    private static class ConfigEntry {
        private Boolean enabled;
        private String description = null;

        public ConfigEntry(Boolean enabled) {
            this.enabled = enabled;
        }

        public ConfigEntry(Boolean enabled, String description) {
            this(enabled);
            this.description = description;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class FileNotReadWritableException
    extends RuntimeException {
        public FileNotReadWritableException(String message) {
            super(message);
        }
    }
}

