/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.loader;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.loader.AtomicFiles;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public abstract class AbstractConfigurationLoader<NodeType extends ConfigurationNode>
implements ConfigurationLoader<NodeType> {
    protected static final Splitter LINE_SPLITTER = Splitter.on('\n');
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Charset UTF8_CHARSET = Charset.forName("utf-8");
    protected final CharSource source;
    private final CharSink sink;
    private final CommentHandler[] commentHandlers;
    private final boolean preservesHeader;

    protected AbstractConfigurationLoader(CharSource source, CharSink sink, CommentHandler[] commentHandlers, boolean preservesHeader) {
        this.source = source;
        this.sink = sink;
        this.commentHandlers = commentHandlers;
        this.preservesHeader = preservesHeader;
    }

    public CommentHandler getDefaultCommentHandler() {
        return this.commentHandlers[0];
    }

    @Override
    public NodeType load() throws IOException {
        return this.load(ConfigurationOptions.defaults());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeType load(ConfigurationOptions options) throws IOException {
        if (!this.canLoad()) {
            throw new IOException("No source present to read from!");
        }
        try {
            Object NodeType;
            BufferedReader reader;
            block17: {
                reader = this.source.openBufferedStream();
                Throwable throwable = null;
                try {
                    String comment;
                    if (this.preservesHeader && (comment = CommentHandlers.extractComment(reader, this.commentHandlers)) != null && comment.length() > 0) {
                        options = options.setHeader(comment);
                    }
                    Object node = this.createEmptyNode(options);
                    this.loadInternal(node, reader);
                    NodeType = node;
                    if (reader == null) return NodeType;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader == null) throw throwable4;
                        if (throwable == null) {
                            reader.close();
                            throw throwable4;
                        }
                        try {
                            reader.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    reader.close();
                    return NodeType;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return NodeType;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return NodeType;
                    }
                }
            }
            reader.close();
            return NodeType;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.createEmptyNode(options);
        }
    }

    protected abstract void loadInternal(NodeType var1, BufferedReader var2) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void save(ConfigurationNode node) throws IOException {
        Writer writer;
        block16: {
            if (!this.canSave()) {
                throw new IOException("No sink present to write to!");
            }
            writer = this.sink.openBufferedStream();
            Throwable throwable = null;
            try {
                String header = node.getOptions().getHeader();
                if (header != null && !header.isEmpty()) {
                    for (String line : this.getDefaultCommentHandler().toComment(ImmutableList.copyOf(LINE_SPLITTER.split(header)))) {
                        writer.write(line);
                        writer.write(LINE_SEPARATOR);
                    }
                    writer.write(LINE_SEPARATOR);
                }
                this.saveInternal(node, writer);
                if (writer == null) return;
                if (throwable == null) break block16;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (writer == null) throw throwable4;
                    if (throwable == null) {
                        writer.close();
                        throw throwable4;
                    }
                    try {
                        writer.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable4;
                        }
                    }
                }
            }
            try {
                writer.close();
                return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    return;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return;
                }
            }
        }
        writer.close();
    }

    protected abstract void saveInternal(ConfigurationNode var1, Writer var2) throws IOException;

    public boolean canLoad() {
        return this.source != null;
    }

    public boolean canSave() {
        return this.sink != null;
    }

    static {
        assert (UTF8_CHARSET != null);
    }

    protected static abstract class Builder<T extends Builder> {
        protected boolean preserveHeader = true;
        protected CharSource source;
        protected CharSink sink;

        protected Builder() {
        }

        private T self() {
            return (T)this;
        }

        public T setFile(File file) {
            this.source = Files.asCharSource(file, UTF8_CHARSET);
            this.sink = AtomicFiles.asCharSink(file, UTF8_CHARSET);
            return this.self();
        }

        public T setURL(URL url) {
            this.source = Resources.asCharSource(url, UTF8_CHARSET);
            return this.self();
        }

        public T setSource(CharSource source) {
            this.source = source;
            return this.self();
        }

        public T setSink(CharSink sink) {
            this.sink = sink;
            return this.self();
        }

        public T setPreservesHeader(boolean preservesHeader) {
            this.preserveHeader = preservesHeader;
            return this.self();
        }

        public abstract AbstractConfigurationLoader build();
    }
}

