/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;

@SideOnly(value=Side.CLIENT)
public class TextDataRenderer {
    public static String drawText(int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, FontRenderer fr) {
        String action = "";
        String[] drawLabel = null;
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextData item : data) {
            int box1W = 9999;
            int box1H = y + fr.field_78288_b;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item.text == null || item.text.isEmpty()) continue;
            if (item.text.equals("\n")) {
                atX = x;
                atY += fr.field_78288_b;
                continue;
            }
            if (item.paragraph) {
                atX = x;
                atY = (int)((float)atY + (float)(fr.field_78288_b * 2) * prevScale);
            }
            prevScale = item.scale;
            String modifiers = "";
            modifiers = modifiers + TextFormatting.func_96300_b((String)item.color);
            if (item.bold) {
                modifiers = modifiers + TextFormatting.BOLD;
            }
            if (item.italic) {
                modifiers = modifiers + TextFormatting.ITALIC;
            }
            if (item.underlined) {
                modifiers = modifiers + TextFormatting.UNDERLINE;
            }
            if (item.strikethrough) {
                modifiers = modifiers + TextFormatting.STRIKETHROUGH;
            }
            if (item.obfuscated) {
                modifiers = modifiers + TextFormatting.OBFUSCATED;
            }
            String text = TextDataRenderer.translateString(item.text);
            String[] split = TextDataRenderer.cropStringBySize(text, modifiers, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int i = 0; i < split.length; ++i) {
                if (i == split.length - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                String s = split[i];
                TextDataRenderer.drawScaledString(fr, modifiers + s, atX, atY, 0, item.dropshadow, item.scale);
                if (i < split.length - 1) {
                    atY += fr.field_78288_b;
                    atX = x;
                }
                if (i != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.func_78256_a(split[split.length - 1]) * item.scale)) - x >= boxWidth) {
                atX = x;
                atY = (int)((float)atY + (float)fr.field_78288_b * item.scale);
            }
            int box3W = atX;
            int box3H = (int)((float)atY + (float)fr.field_78288_b * item.scale);
            if (item.tooltip != null && item.tooltip.length > 0 && (mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H)) {
                drawLabel = item.tooltip;
            }
            if (item.action != null && !item.action.isEmpty() && (mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H)) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                fr.func_175065_a("...", (float)atX, (float)atY, 0, item.dropshadow);
                break;
            }
            y = atY;
        }
        if (GuiBook.debug && action != null && !action.isEmpty()) {
            String[] label = drawLabel;
            drawLabel = new String[label != null ? label.length + 2 : 1];
            if (label != null) {
                for (int i = 0; i < label.length; ++i) {
                    drawLabel[i] = label[i];
                }
            }
            drawLabel[drawLabel.length > 1 ? drawLabel.length - 2 : 0] = "";
            drawLabel[drawLabel.length - 1] = TextFormatting.GRAY + "Action: " + action;
        }
        if (drawLabel != null) {
            TextDataRenderer.drawHoveringText(drawLabel, mouseX, mouseY, fr);
        }
        return action;
    }

    public static String translateString(String s) {
        s = s.replace("$$(", "$\u0000(").replace(")$$", ")\u0000$");
        while (s.contains("$(") && s.contains(")$") && s.indexOf("$(") < s.indexOf(")$")) {
            String loc = s.substring(s.indexOf("$(") + 2, s.indexOf(")$"));
            s = s.replace("$(" + loc + ")$", I18n.func_74838_a((String)loc));
        }
        if (s.indexOf("$(") > s.indexOf(")$") || s.contains(")$")) {
            Mantle.logger.error("[Books] [TextDataRenderer] Detected unbalanced localization symbols \"$(\" and \")$\" in string: \"" + s + "\".");
        }
        return s.replace("$\u0000(", "$(").replace(")\u0000$", ")$");
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, FontRenderer fr, float scale) {
        return TextDataRenderer.cropStringBySize(s, modifiers, width, height, width, fr, scale);
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, int firstWidth, FontRenderer fr, float scale) {
        int curWidth = 0;
        int curHeight = (int)((float)fr.field_78288_b * scale);
        for (int i = 0; i < s.length(); ++i) {
            curWidth = (int)((float)curWidth + (float)fr.func_78256_a(modifiers + Character.toString(s.charAt(i))) * scale);
            if (s.charAt(i) != '\n' && (curHeight != (int)((float)fr.field_78288_b * scale) || curWidth <= firstWidth) && (curHeight == (int)((float)fr.field_78288_b * scale) || curWidth <= width)) continue;
            int oldI = i;
            while (i >= 0 && s.charAt(i) != ' ') {
                --i;
            }
            if (i <= 0) {
                i = oldI;
            }
            s = s.substring(0, i).trim() + "\r" + s.substring(i + (i == oldI ? 0 : 1)).trim();
            ++i;
            curWidth = 0;
            if ((curHeight = (int)((float)curHeight + (float)fr.field_78288_b * scale)) < height) continue;
            return s.substring(0, i).trim().split("\r");
        }
        return s.split("\r");
    }

    private static void drawHoveringText(String[] textLines, int x, int y, FontRenderer font) {
        GuiUtils.drawHoveringText(ImmutableList.copyOf(textLines), (int)x, (int)y, (int)GuiBook.PAGE_WIDTH, (int)GuiBook.PAGE_HEIGHT, (int)GuiBook.PAGE_WIDTH, (FontRenderer)font);
        RenderHelper.func_74518_a();
    }

    public static void drawScaledString(FontRenderer font, String text, float x, float y, int color, boolean dropShadow, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        font.func_175065_a(text, 0.0f, 0.0f, color, dropShadow);
        GlStateManager.func_179121_F();
    }

    private static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexBuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

