/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.StatisticsManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.gui.book.GuiArrow;
import slimeknights.mantle.client.gui.book.GuiBookmark;
import slimeknights.mantle.client.gui.book.Textures;
import slimeknights.mantle.client.gui.book.element.BookElement;

@SideOnly(value=Side.CLIENT)
public class GuiBook
extends GuiScreen
implements IProgressMeter {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static int PAGE_MARGIN = 8;
    public static int PAGE_PADDING_TOP = 4;
    public static int PAGE_PADDING_BOT = 4;
    public static int PAGE_PADDING_LEFT = 8;
    public static int PAGE_PADDING_RIGHT = 0;
    public static float PAGE_SCALE = 1.0f;
    public static int PAGE_WIDTH_UNSCALED = 206;
    public static int PAGE_HEIGHT_UNSCALED = 200;
    public static int PAGE_WIDTH;
    public static int PAGE_HEIGHT;
    private boolean loadingAchievements = true;
    private GuiArrow previousArrow;
    private GuiArrow nextArrow;
    private GuiArrow backArrow;
    private GuiArrow indexArrow;
    public final BookData book;
    private ItemStack item;
    private int page = -1;
    private int oldPage = -2;
    private ArrayList<BookElement> leftElements = new ArrayList();
    private ArrayList<BookElement> rightElements = new ArrayList();
    public StatisticsManager statisticsManager;

    public static void init() {
        PAGE_WIDTH = (int)((float)(PAGE_WIDTH_UNSCALED - (PAGE_PADDING_LEFT + PAGE_PADDING_RIGHT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
        PAGE_HEIGHT = (int)((float)(PAGE_HEIGHT_UNSCALED - (PAGE_PADDING_TOP + PAGE_PADDING_BOT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
    }

    public GuiBook(BookData book, StatisticsManager statisticsManager, @Nullable ItemStack item) {
        this.book = book;
        this.item = item;
        this.statisticsManager = statisticsManager;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        GuiBook.init();
    }

    public void drawerTransform(boolean rightSide) {
        if (rightSide) {
            GlStateManager.func_179109_b((float)(this.field_146294_l / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN), (float)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        } else {
            GlStateManager.func_179109_b((float)(this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN), (float)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.field_146294_l / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN;
        }
        return this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN;
    }

    protected float topOffset() {
        return this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN;
    }

    protected int getMouseX(boolean rightSide) {
        return (int)(((float)(Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c) - this.leftOffset(rightSide)) / PAGE_SCALE);
    }

    protected int getMouseY() {
        return (int)(((float)(this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1) - this.topOffset()) / PAGE_SCALE);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiBook.init();
        FontRenderer fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = this.field_146297_k.field_71466_p;
        }
        if (this.loadingAchievements) {
            this.func_146276_q_();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"multiplayer.downloadingStats", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, field_146510_b_[(int)(Minecraft.func_71386_F() / 150L % (long)field_146510_b_.length)], this.field_146294_l / 2, this.field_146295_m / 2 + this.field_146289_q.field_78288_b * 2, 0xFFFFFF);
            return;
        }
        if (debug) {
            GuiBook.func_73734_a((int)0, (int)0, (int)(fontRenderer.func_78256_a("DEBUG") + 4), (int)(fontRenderer.field_78288_b + 4), (int)0x55000000);
            fontRenderer.func_78276_b("DEBUG", 2, 2, -1);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float coverR = (float)(this.book.appearance.coverColor >> 16 & 0xFF) / 255.0f;
        float coverG = (float)(this.book.appearance.coverColor >> 8 & 0xFF) / 255.0f;
        float coverB = (float)(this.book.appearance.coverColor & 0xFF) / 255.0f;
        TextureManager render = this.field_146297_k.field_71446_o;
        if (this.page == -1) {
            render.func_110577_a(Textures.TEX_BOOKFRONT);
            RenderHelper.func_74518_a();
            GlStateManager.func_179124_c((float)coverR, (float)coverG, (float)coverB);
            GuiBook.func_146110_a((int)(this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.book.appearance.title.isEmpty()) {
                GuiBook.func_146110_a((int)(this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
                GlStateManager.func_179094_E();
                float scale = fontRenderer.func_78256_a(this.book.appearance.title) <= 67 ? 2.5f : 2.0f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                fontRenderer.func_175065_a(this.book.appearance.title, (float)(this.field_146294_l / 2) / scale + 3.0f - (float)(fontRenderer.func_78256_a(this.book.appearance.title) / 2), (float)(this.field_146295_m / 2 - fontRenderer.field_78288_b / 2) / scale - 4.0f, 11436032, true);
                GlStateManager.func_179121_F();
            }
            if (!this.book.appearance.subtitle.isEmpty()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
                fontRenderer.func_175065_a(this.book.appearance.subtitle, (float)(this.field_146294_l / 2) / 1.5f + 7.0f - (float)(fontRenderer.func_78256_a(this.book.appearance.subtitle) / 2), (float)(this.field_146295_m / 2 + 100 - fontRenderer.field_78288_b * 2) / 1.5f, 11436032, true);
                GlStateManager.func_179121_F();
            }
        } else {
            BookElement element;
            int i;
            int mY;
            render.func_110577_a(Textures.TEX_BOOK);
            RenderHelper.func_74518_a();
            GlStateManager.func_179124_c((float)coverR, (float)coverG, (float)coverB);
            GuiBook.func_146110_a((int)(this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED), (int)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)(PAGE_WIDTH_UNSCALED * 2), (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.page != 0) {
                GuiBook.func_146110_a((int)(this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED), (int)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
                GlStateManager.func_179094_E();
                this.drawerTransform(false);
                GlStateManager.func_179152_a((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 2 + "";
                    fontRenderer.func_175065_a(pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.func_78256_a(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406, false);
                }
                int mX = this.getMouseX(false);
                mY = this.getMouseY();
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(mX, mY, partialTicks, fontRenderer);
                }
                GlStateManager.func_179121_F();
            }
            render.func_110577_a(Textures.TEX_BOOK);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            if ((this.page < this.book.getFullPageCount(this.statisticsManager) - 1 || this.book.getPageCount(this.statisticsManager) % 2 != 0) && this.page < this.book.getFullPageCount(this.statisticsManager)) {
                GuiBook.func_146110_a((int)(this.field_146294_l / 2), (int)(this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)PAGE_WIDTH_UNSCALED, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
                GlStateManager.func_179094_E();
                this.drawerTransform(true);
                GlStateManager.func_179152_a((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 3 + "";
                    fontRenderer.func_175065_a(pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.func_78256_a(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406, false);
                }
                int mX = this.getMouseX(true);
                mY = this.getMouseY();
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(mX, mY, partialTicks, fontRenderer);
                }
                GlStateManager.func_179121_F();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (this.loadingAchievements) {
            return -1;
        }
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.statisticsManager)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public ArrayList<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : null);
    }

    public void openCover() {
        if (this.loadingAchievements) {
            return;
        }
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    public void itemClicked(ItemStack item) {
        StringActionProcessor.process(this.book.getItemAction(ItemStackData.getItemStackData(item, true)), this);
    }

    private void buildPages() {
        if (this.loadingAchievements) {
            return;
        }
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.statisticsManager);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.statisticsManager);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.statisticsManager);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.loadingAchievements) {
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new CPacketClientStatus(CPacketClientStatus.State.REQUEST_STATS));
            return;
        }
        this.previousArrow = new GuiArrow(0, -50, -50, GuiArrow.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.nextArrow = new GuiArrow(1, -50, -50, GuiArrow.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.backArrow = new GuiArrow(2, this.field_146294_l / 2 - 9, this.field_146295_m / 2 + 5 + PAGE_HEIGHT / 2, GuiArrow.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.indexArrow = new GuiArrow(3, this.field_146294_l / 2 - PAGE_WIDTH_UNSCALED - 9, this.field_146295_m / 2 - PAGE_HEIGHT_UNSCALED / 2, GuiArrow.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.field_146292_n.clear();
        this.field_146292_n.add(this.previousArrow);
        this.field_146292_n.add(this.nextArrow);
        this.field_146292_n.add(this.backArrow);
        this.field_146292_n.add(this.indexArrow);
        this.buildPages();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.loadingAchievements) {
            return;
        }
        this.previousArrow.field_146125_m = this.page != -1;
        this.nextArrow.field_146125_m = this.page < this.book.getFullPageCount(this.statisticsManager) - (this.book.getPageCount(this.statisticsManager) % 2 != 0 ? 0 : 1);
        boolean bl = this.backArrow.field_146125_m = this.oldPage >= -1;
        if (this.page == -1) {
            this.nextArrow.field_146128_h = this.field_146294_l / 2 + 80;
            this.indexArrow.field_146125_m = false;
        } else {
            this.previousArrow.field_146128_h = this.field_146294_l / 2 - 184;
            this.nextArrow.field_146128_h = this.field_146294_l / 2 + 165;
            this.indexArrow.field_146125_m = this.book.findSection("index") != null && (this.page - 1) * 2 + 2 > this.book.findSection("index").getPageCount();
        }
        this.previousArrow.field_146129_i = this.field_146295_m / 2 + 75;
        this.nextArrow.field_146129_i = this.field_146295_m / 2 + 75;
    }

    public void func_146509_g() {
        this.loadingAchievements = false;
        this.func_73866_w_();
        this.openPage(this.book.findPageNumber(BookHelper.getSavedPage(this.item), this.statisticsManager));
    }

    public void func_146284_a(GuiButton button) {
        if (this.loadingAchievements) {
            return;
        }
        if (button instanceof GuiBookmark) {
            this.openPage(this.book.findPageNumber(((GuiBookmark)button).data.page, this.statisticsManager));
            return;
        }
        if (button == this.previousArrow) {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
        } else if (button == this.nextArrow) {
            ++this.page;
            if (this.page > this.book.getFullPageCount(this.statisticsManager) - (this.book.getPageCount(this.statisticsManager) % 2 != 0 ? 0 : 1)) {
                this.page = this.book.getFullPageCount(this.statisticsManager) - 1;
            }
        } else if (button == this.backArrow) {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
        } else if (button == this.indexArrow) {
            this.openPage(this.book.findPageNumber("index.page1"));
        }
        this.oldPage = -2;
        this.buildPages();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.loadingAchievements) {
            return;
        }
        switch (keyCode) {
            case 30: 
            case 203: {
                this.func_146284_a(this.previousArrow);
                break;
            }
            case 32: 
            case 205: {
                this.func_146284_a(this.nextArrow);
                break;
            }
            case 61: {
                debug = !debug;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.loadingAchievements) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if ((float)mouseX > (float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseClicked(mouseX, mouseY, mouseButton);
            ++i;
        }
    }

    public void func_146281_b() {
        PageData page;
        if (this.loadingAchievements) {
            return;
        }
        if (this.field_146297_k.field_71439_g == null) {
            return;
        }
        PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.statisticsManager) : this.book.findPage((this.page - 1) * 2 + 1, this.statisticsManager);
        if (page == null) {
            page = this.book.findPage((this.page - 1) * 2 + 2, this.statisticsManager);
        }
        if (this.page == -1) {
            BookLoader.updateSavedPage((EntityPlayer)this.field_146297_k.field_71439_g, this.item, "");
        } else if (page != null && page.parent != null) {
            BookLoader.updateSavedPage((EntityPlayer)this.field_146297_k.field_71439_g, this.item, page.parent.name + "." + page.name);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        GuiBook.init();
    }
}

