/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.loader;

import com.google.common.io.ByteSink;
import com.google.common.io.CharSink;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import ninja.leaping.configurate.loader.AtomicFileOutputStream;

public class AtomicFiles {
    public static ByteSink asByteSink(File file) {
        return new AtomicFileByteSink(file);
    }

    public static CharSink asCharSink(File file, Charset charset) {
        return AtomicFiles.asByteSink(file).asCharSink(charset);
    }

    private static class AtomicFileByteSink
    extends ByteSink {
        private final File file;

        private AtomicFileByteSink(File file) {
            this.file = file;
        }

        @Override
        public OutputStream openStream() throws IOException {
            return new AtomicFileOutputStream(this.file);
        }
    }
}

