/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.opengl.GL11;
import slimeknights.mantle.client.book.data.element.BlockData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

public class ElementStructure
extends SizedBookElement {
    private BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
    private ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
    private BlockAccess world;
    private float scale = 50.0f;
    private float xTranslate = 0.0f;
    private float yTranslate = 0.0f;
    private float w = 0.0f;
    private float h = 0.0f;
    private float rotX = -11.25f;
    private float rotY = 45.0f;
    private float rotZ = 0.0f;

    public ElementStructure(int x, int y, int width, int height, int[] size, BlockData[] structure) {
        super(x, y, width, height);
        this.world = new BlockAccess(size, structure);
        if (size.length == 3) {
            float f = this.scale = size[0] > size[1] ? (float)(width / size[0]) - 10.0f : (float)(height / size[1]) - 10.0f;
            if (this.scale * (float)size[0] > (float)width) {
                this.scale = (float)(width / size[0]) - 10.0f;
            }
            this.xTranslate = (float)(x + width / 2) - (float)size[0] * this.scale / 2.0f;
            this.yTranslate = (float)(y + height / 2) - (float)size[1] * this.scale / 2.0f;
            this.w = (float)size[0] * this.scale;
            this.h = (float)size[1] * this.scale;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.xTranslate, (float)this.yTranslate, (float)500.0f);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glVertex2i((int)0, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)0);
        GL11.glEnd();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glVertex2i((int)0, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)0);
        GL11.glEnd();
        GlStateManager.func_179109_b((float)(this.w / 2.0f), (float)(this.h / 2.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-this.w / 2.0f), (float)(-this.h / 2.0f), (float)0.0f);
        for (int x = 0; x < this.world.getWidth(); ++x) {
            for (int y = 0; y < this.world.getHeight(); ++y) {
                for (int z = 0; z < this.world.getDepth(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.world.func_180495_p(pos);
                    IBakedModel model = this.mc.func_175602_ab().func_184389_a(state);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a) continue;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179126_j();
                    this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    if (block == null) {
                        return;
                    }
                    int color = this.blockColors.func_186724_a(state, (IBlockAccess)this.world, pos, 0);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                    GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
                    GlStateManager.func_179109_b((float)x, (float)(this.world.getHeight() - y), (float)z);
                    BlockModelRenderer render = this.mc.func_175602_ab().func_175019_b();
                    int i = this.blockColors.func_186724_a(state, (IBlockAccess)this.world, pos, 0);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (EntityRenderer.field_78517_a) {
                        i = TextureUtil.func_177054_c((int)i);
                    }
                    float r = (float)(i >> 16 & 0xFF) / 255.0f;
                    float g = (float)(i >> 8 & 0xFF) / 255.0f;
                    float b = (float)(i & 0xFF) / 255.0f;
                    render.func_178262_a(model, (float)this.blockColors.func_186724_a(state, (IBlockAccess)this.world, pos, 0), r, g, b);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                    this.renderEngine.func_110581_b(TextureMap.field_110575_b).func_174935_a();
                }
            }
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GL11.glDisable((int)2960);
        GlStateManager.func_179121_F();
    }

    private void setupGuiTransform(int xPosition, int yPosition) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)(100.0f + this.field_73735_i));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179152_a((float)40.0f, (float)40.0f, (float)40.0f);
        GlStateManager.func_179114_b((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179145_e();
    }

    private void renderQuads(VertexBuffer renderer, List<BakedQuad> quads, int color, BlockPos pos) {
        boolean flag = color == -1;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                Block block = this.world.func_180495_p(pos).func_177230_c();
                k = this.blockColors.func_186724_a(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos, 0);
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((VertexBuffer)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    private class BlockAccess
    implements IBlockAccess {
        private final int[][][] blocks;
        private final byte[][][] meta;
        private final int[] size;
        private HashMap<Integer[], TileEntity> tileEntityMap = new HashMap();

        public BlockAccess(int[] size, BlockData[] structure) {
            this.size = size;
            this.blocks = new int[size[0]][size[1]][size[2]];
            this.meta = new byte[size[0]][size[1]][size[2]];
            for (BlockData block : structure) {
                byte metadata;
                Block tile = Block.func_149684_b((String)block.block);
                if (tile == null) continue;
                byte by = metadata = block.meta >= 0 && block.meta < 16 ? block.meta : (byte)0;
                if (block.pos == null || block.pos.length != 3 || block.endPos == null || block.endPos.length != 3) continue;
                for (int x = block.pos[0]; x <= block.endPos[0]; ++x) {
                    for (int y = block.pos[1]; y <= block.endPos[1]; ++y) {
                        for (int z = block.pos[2]; z <= block.endPos[2]; ++z) {
                            TileEntity te;
                            if (x >= size[0] || y >= size[1] || z >= size[2]) continue;
                            this.blocks[x][y][z] = Block.func_149682_b((Block)tile);
                            this.meta[x][y][z] = metadata;
                            TileEntity tileEntity = te = tile.hasTileEntity(tile.func_176203_a((int)metadata)) ? tile.createTileEntity((World)Minecraft.func_71410_x().field_71441_e, tile.func_176203_a((int)metadata)) : null;
                            if (te == null) continue;
                            te.func_174878_a(new BlockPos(x, y, z));
                            this.tileEntityMap.put(new Integer[]{x, y, z}, te);
                            if (block.nbt == null) continue;
                            try {
                                te.func_145839_a(JsonToNBT.func_180713_a((String)ItemStackData.filterJsonQuotes(block.nbt.toString())));
                                continue;
                            }
                            catch (NBTException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }

        public TileEntity func_175625_s(@Nonnull BlockPos pos) {
            if (!this.isValid(pos)) {
                return null;
            }
            return this.tileEntityMap.get(new Integer[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        }

        public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
            return 15;
        }

        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            if (!this.isValid(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            Block block = Block.func_149729_e((int)this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()]);
            if (block == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return block.func_176221_a(block.func_176203_a((int)this.meta[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()]), (IBlockAccess)this, pos);
        }

        public boolean func_175623_d(@Nonnull BlockPos pos) {
            return !this.isValid(pos) || Block.func_149729_e((int)this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()]) == Blocks.field_150350_a;
        }

        @Nonnull
        public Biome func_180494_b(@Nonnull BlockPos blockPos) {
            return Biomes.field_76782_w;
        }

        public boolean func_72806_N() {
            return false;
        }

        public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            if (!this.isValid(pos)) {
                return 0;
            }
            IBlockState iblockstate = this.func_180495_p(pos);
            return iblockstate.func_177230_c().func_176211_b(iblockstate, (IBlockAccess)this, pos, direction);
        }

        @Nonnull
        public WorldType func_175624_G() {
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
            if (!this.isValid(pos)) {
                return _default;
            }
            return this.func_180495_p(pos).func_177230_c().isSideSolid(this.func_180495_p(pos), (IBlockAccess)this, pos, side);
        }

        public boolean isValid(BlockPos pos) {
            return pos != null && pos.func_177958_n() < this.size[0] && pos.func_177956_o() < this.size[1] && pos.func_177952_p() < this.size[2] && pos.func_177958_n() >= 0 && pos.func_177956_o() >= 0 && pos.func_177952_p() >= 0;
        }

        public int getWidth() {
            return this.size[0];
        }

        public int getHeight() {
            return this.size[1];
        }

        public int getDepth() {
            return this.size[2];
        }
    }
}

