/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.stats.Achievement;
import net.minecraft.util.text.TextFormatting;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

public class ElementSection
extends SizedBookElement {
    public static final int IMG_SIZE = 32;
    public static final int WIDTH = 42;
    public static final int HEIGHT = 42;
    private SectionData section;

    public ElementSection(int x, int y, SectionData section) {
        super(x, y, 42, 42);
        this.section = section;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        boolean unlocked = this.section.isUnlocked(this.parent.statisticsManager);
        boolean hover = this.isHovered(mouseX, mouseY);
        if (this.section.icon != null) {
            int iconX = this.x + 21 - 16;
            int iconY = this.y + 21 - 16;
            if (hover) {
                ElementSection.drawRect((int)iconX, (int)iconY, (int)(iconX + 32), (int)(iconY + 32), (int)this.parent.book.appearance.hoverColor);
            }
            if (unlocked) {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 1.0f : 0.5f));
            } else {
                float r = (float)(this.parent.book.appearance.lockedSectionColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.parent.book.appearance.lockedSectionColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.parent.book.appearance.lockedSectionColor & 0xFF) / 255.0f;
                GlStateManager.color((float)r, (float)g, (float)b, (float)0.75f);
            }
            if (this.section.icon.item == null) {
                if (this.section.icon.location != null) {
                    this.renderEngine.bindTexture(this.section.icon.location);
                    ElementSection.drawScaledCustomSizeModalRect((int)iconX, (int)iconY, (float)this.section.icon.u, (float)this.section.icon.v, (int)this.section.icon.uw, (int)this.section.icon.vh, (int)32, (int)32, (float)this.section.icon.texWidth, (float)this.section.icon.texHeight);
                }
            } else {
                GlStateManager.pushMatrix();
                GlStateManager.translate((float)iconX, (float)iconY, (float)0.0f);
                GlStateManager.scale((float)2.0f, (float)2.0f, (float)1.0f);
                RenderHelper.enableGUIStandardItemLighting();
                this.mc.getRenderItem().renderItemAndEffectIntoGUI(this.section.icon.item.getItems()[0], 0, 0);
                RenderHelper.disableStandardItemLighting();
                GlStateManager.popMatrix();
            }
        }
        if (this.section.parent.appearance.drawSectionListText) {
            int textW = fontRenderer.getStringWidth(this.section.getTitle());
            int textX = this.x + 21 - textW / 2;
            int textY = this.y + 42 - fontRenderer.FONT_HEIGHT / 2;
            fontRenderer.drawString(this.section.getTitle(), textX, textY, hover ? -16777216 : 0x7F000000);
        }
    }

    @Override
    public void drawOverlay(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.section != null && this.isHovered(mouseX, mouseY)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(this.section.getTitle());
            if (!this.section.isUnlocked(this.parent.statisticsManager)) {
                text.add(TextFormatting.RED + "Locked");
                text.add("Requirements:");
                for (String requirement : this.section.requirements) {
                    Achievement achievement = SectionData.findAchievement(requirement);
                    if (achievement == null) continue;
                    text.add((SectionData.requirementSatisfied(requirement, this.parent.statisticsManager) ? TextFormatting.GREEN : TextFormatting.RED) + TextFormatting.getTextWithoutFormattingCodes((String)achievement.getStatName().getFormattedText()));
                }
            }
            this.drawHoveringText(text, mouseX, mouseY, fontRenderer);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.section != null && this.section.isUnlocked(this.parent.statisticsManager) && this.isHovered(mouseX, mouseY)) {
            this.parent.openPage(this.parent.book.getFirstPageNumber(this.section, this.parent.statisticsManager));
        }
    }
}

