/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.util;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import ninja.leaping.configurate.ConfigurationNode;

public class MapFactories {
    private MapFactories() {
    }

    public static <V extends ConfigurationNode> Supplier<ConcurrentMap<Object, V>> unordered() {
        return new EqualsSupplier<ConcurrentMap<Object, V>>(){

            @Override
            public ConcurrentMap<Object, V> get() {
                return new ConcurrentHashMap();
            }
        };
    }

    public static <V extends ConfigurationNode> Supplier<ConcurrentMap<Object, V>> sorted(final Comparator<Object> comparator) {
        return new EqualsSupplier<ConcurrentMap<Object, V>>(){

            @Override
            public ConcurrentMap<Object, V> get() {
                return new ConcurrentSkipListMap(comparator);
            }
        };
    }

    public static <V extends ConfigurationNode> Supplier<ConcurrentMap<Object, V>> sortedNatural() {
        return new EqualsSupplier<ConcurrentMap<Object, V>>(){

            @Override
            public ConcurrentMap<Object, V> get() {
                return new ConcurrentSkipListMap();
            }
        };
    }

    public static <V extends ConfigurationNode> Supplier<ConcurrentMap<Object, V>> insertionOrdered() {
        return new EqualsSupplier<ConcurrentMap<Object, V>>(){

            @Override
            public ConcurrentMap<Object, V> get() {
                return new SynchronizedWrapper(new LinkedHashMap());
            }
        };
    }

    private static abstract class EqualsSupplier<V>
    implements Supplier<V> {
        private EqualsSupplier() {
        }

        public boolean equals(Object o) {
            return o.getClass().equals(this.getClass());
        }
    }

    private static class SynchronizedWrapper<K, V>
    implements ConcurrentMap<K, V> {
        private final Map<K, V> wrapped;

        private SynchronizedWrapper(Map<K, V> wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K k, V v) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (this.wrapped.containsKey(k)) {
                    return this.wrapped.get(k);
                }
                this.wrapped.put(k, v);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object expected) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (Objects.equal(expected, this.wrapped.get(key))) {
                    return this.wrapped.remove(key) != null;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V old, V replace) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (Objects.equal(old, this.wrapped.get(key))) {
                    this.wrapped.put(key, replace);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K k, V v) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (this.wrapped.containsKey(k)) {
                    return this.wrapped.put(k, v);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.containsKey(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.containsKey(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.get(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Map<K, V> map2 = this.wrapped;
            synchronized (map2) {
                this.wrapped.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                this.wrapped.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return ImmutableSet.copyOf(this.wrapped.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return ImmutableSet.copyOf(this.wrapped.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return ImmutableSet.copyOf(this.wrapped.entrySet());
            }
        }
    }
}

