/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.tileentity;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileInventory
extends TileEntity
implements IInventory {
    private ItemStack[] inventory;
    protected String inventoryTitle;
    protected boolean hasCustomName;
    protected int stackSizeLimit;
    protected IItemHandlerModifiable itemHandler;

    public TileInventory(String name, int inventorySize) {
        this(name, inventorySize, 64);
    }

    public TileInventory(String name, int inventorySize, int maxStackSize) {
        this.inventory = new ItemStack[inventorySize];
        this.stackSizeLimit = maxStackSize;
        this.inventoryTitle = name;
        this.itemHandler = new InvWrapper((IInventory)this);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        return this.func_70301_a(slot) != null;
    }

    public void resize(int size) {
        this.inventory = Arrays.copyOf(this.inventory, size);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public int func_70297_j_() {
        return this.stackSizeLimit;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (slot < 0 || slot >= this.inventory.length) {
            return;
        }
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack == null) {
            return null;
        }
        if (itemStack.field_77994_a <= quantity) {
            this.func_70299_a(slot, null);
            this.func_70296_d();
            return itemStack;
        }
        itemStack = itemStack.func_77979_a(quantity);
        if (this.func_70301_a((int)slot).field_77994_a == 0) {
            this.func_70299_a(slot, null);
        }
        this.func_70296_d();
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return itemStack;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
        return slot < this.func_70302_i_() && (this.inventory[slot] == null || itemstack.field_77994_a + this.inventory[slot].field_77994_a <= this.func_70297_j_());
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this.inventoryTitle;
    }

    public boolean func_145818_k_() {
        return this.hasCustomName;
    }

    public void setCustomName(String customName) {
        this.hasCustomName = true;
        this.inventoryTitle = customName;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this || this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.resize(tags.func_74762_e("InventorySize"));
        this.readInventoryFromNBT(tags);
        if (tags.func_150297_b("CustomName", 8)) {
            this.inventoryTitle = tags.func_74779_i("CustomName");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74768_a("InventorySize", this.inventory.length);
        this.writeInventoryToNBT(tags);
        if (this.func_145818_k_()) {
            tags.func_74778_a("CustomName", this.inventoryTitle);
        }
        return tags;
    }

    public void writeInventoryToNBT(NBTTagCompound tag) {
        TileInventory inventory = this;
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            inventory.func_70301_a(i).func_77955_b(itemTag);
            nbttaglist.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void readInventoryFromNBT(NBTTagCompound tag) {
        TileInventory inventory = this;
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound itemTag = nbttaglist.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemTag));
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

