/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.SlotWrapper;

public class ContainerMultiModule<T extends TileEntity>
extends BaseContainer<T> {
    public List<Container> subContainers = Lists.newArrayList();
    protected Map<Integer, Container> slotContainerMap = Maps.newHashMap();
    protected Map<Container, Pair<Integer, Integer>> subContainerSlotRanges = Maps.newHashMap();
    protected int subContainerSlotStart = -1;
    protected Set<Container> shiftClickContainers = Sets.newHashSet();

    public ContainerMultiModule(T tile) {
        super(tile);
    }

    public void addSubContainer(Container subcontainer, boolean preferForShiftClick) {
        if (this.subContainers.isEmpty()) {
            this.subContainerSlotStart = this.inventorySlots.size();
        }
        this.subContainers.add(subcontainer);
        if (preferForShiftClick) {
            this.shiftClickContainers.add(subcontainer);
        }
        int begin = this.inventorySlots.size();
        for (Object slot : subcontainer.inventorySlots) {
            SlotWrapper wrapper = new SlotWrapper((Slot)slot);
            this.addSlotToContainer(wrapper);
            this.slotContainerMap.put(wrapper.slotNumber, subcontainer);
        }
        int end = this.inventorySlots.size();
        this.subContainerSlotRanges.put(subcontainer, (Pair<Integer, Integer>)Pair.of((Object)begin, (Object)end));
    }

    public <TC extends Container> TC getSubContainer(Class<TC> clazz) {
        return this.getSubContainer(clazz, 0);
    }

    public <TC extends Container> TC getSubContainer(Class<TC> clazz, int index) {
        for (Container sub : this.subContainers) {
            if (clazz.isAssignableFrom(sub.getClass())) {
                --index;
            }
            if (index >= 0) continue;
            return (TC)sub;
        }
        return null;
    }

    public Container getSlotContainer(int slotNumber) {
        if (this.slotContainerMap.containsKey(slotNumber)) {
            return this.slotContainerMap.get(slotNumber);
        }
        return this;
    }

    @Override
    public boolean canInteractWith(@Nonnull EntityPlayer playerIn) {
        for (Container sub : this.subContainers) {
            if (sub.canInteractWith(playerIn)) continue;
            return false;
        }
        return super.canInteractWith(playerIn);
    }

    public void onContainerClosed(EntityPlayer playerIn) {
        for (Container sub : this.subContainers) {
            sub.onContainerClosed(playerIn);
        }
        super.onContainerClosed(playerIn);
    }

    public ItemStack slotClick(int slotId, int dragType, ClickType type, EntityPlayer player) {
        if (slotId == -999 && type == ClickType.QUICK_CRAFT) {
            for (Container container : this.subContainers) {
                container.slotClick(slotId, dragType, type, player);
            }
        }
        return super.slotClick(slotId, dragType, type, player);
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot == null || !slot.getHasStack()) {
            return null;
        }
        ItemStack ret = slot.getStack().copy();
        ItemStack itemstack = slot.getStack().copy();
        Container container = this.getSlotContainer(index);
        boolean nothingDone = true;
        if (container != this) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        } else if (index < this.subContainerSlotStart || index < this.playerInventoryStart && this.subContainerSlotStart < 0) {
            nothingDone &= this.refillAnyContainer(itemstack, this.subContainers);
            nothingDone &= this.moveToPlayerInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else if (index >= this.playerInventoryStart && this.playerInventoryStart >= 0) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else {
            return null;
        }
        if (nothingDone) {
            return null;
        }
        return this.notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
    }

    protected ItemStack notifySlotAfterTransfer(EntityPlayer player, ItemStack stack, ItemStack original, Slot slot) {
        slot.onSlotChange(stack, original);
        if (stack.stackSize == original.stackSize) {
            return null;
        }
        slot.putStack(stack);
        slot.onPickupFromSlot(player, stack);
        if (slot.getHasStack() && slot.getStack().stackSize == 0) {
            slot.putStack(null);
        }
        return original;
    }

    protected boolean moveToTileInventory(ItemStack itemstack) {
        if (itemstack == null || itemstack.stackSize == 0) {
            return false;
        }
        int end = this.subContainerSlotStart;
        if (end < 0) {
            end = this.playerInventoryStart;
        }
        return !this.mergeItemStack(itemstack, 0, end, false);
    }

    protected boolean moveToPlayerInventory(ItemStack itemstack) {
        if (itemstack == null || itemstack.stackSize == 0) {
            return false;
        }
        return this.playerInventoryStart > 0 && !this.mergeItemStack(itemstack, this.playerInventoryStart, this.inventorySlots.size(), true);
    }

    protected boolean moveToAnyContainer(ItemStack itemstack, Collection<Container> containers) {
        if (itemstack == null || itemstack.stackSize == 0) {
            return false;
        }
        for (Container submodule : containers) {
            if (!this.moveToContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean moveToContainer(ItemStack itemstack, Container container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.mergeItemStack(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    protected boolean refillAnyContainer(ItemStack itemstack, Collection<Container> containers) {
        if (itemstack == null || itemstack.stackSize == 0) {
            return false;
        }
        for (Container submodule : containers) {
            if (!this.refillContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean refillContainer(ItemStack itemstack, Container container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.mergeItemStackRefill(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    public <TE extends TileEntity> TE detectTE(Class<TE> clazz) {
        return (TE)((TileEntity)ObjectUtils.firstNonNull((Object[])new TileEntity[]{this.detectChest(this.pos.north(), clazz), this.detectChest(this.pos.east(), clazz), this.detectChest(this.pos.south(), clazz), this.detectChest(this.pos.west(), clazz)}));
    }

    private <TE extends TileEntity> TE detectChest(BlockPos pos, Class<TE> clazz) {
        TileEntity te = this.world.getTileEntity(pos);
        if (te != null && clazz.isAssignableFrom(te.getClass())) {
            return (TE)te;
        }
        return null;
    }
}

