/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.Mantle;

public abstract class RecipeMatch {
    public final int amountNeeded;
    public final int amountMatched;

    public RecipeMatch(int amountMatched, int amountNeeded) {
        this.amountMatched = amountMatched;
        this.amountNeeded = amountNeeded;
    }

    public abstract List<ItemStack> getInputs();

    public abstract Match matches(ItemStack[] var1);

    public static RecipeMatch of(String oredict) {
        return RecipeMatch.of(oredict, 1);
    }

    public static RecipeMatch of(String oredict, int matched) {
        return RecipeMatch.of(oredict, 1, matched);
    }

    public static RecipeMatch of(String oredict, int amount, int matched) {
        return new Oredict(oredict, amount, matched);
    }

    public static RecipeMatch of(List<ItemStack> oredict) {
        return RecipeMatch.of(oredict, 1);
    }

    public static RecipeMatch of(List<ItemStack> oredict, int matched) {
        return RecipeMatch.of(oredict, 1, matched);
    }

    public static RecipeMatch of(List<ItemStack> oredict, int amount, int matched) {
        return new Oredict(oredict, amount, matched);
    }

    public static RecipeMatch of(net.minecraft.item.Item item) {
        return RecipeMatch.of(item, 1);
    }

    public static RecipeMatch of(net.minecraft.item.Item item, int matched) {
        return RecipeMatch.of(item, 1, matched);
    }

    public static RecipeMatch of(net.minecraft.item.Item item, int amount, int matched) {
        return new Item(new ItemStack(item), amount, matched);
    }

    public static RecipeMatch of(Block block) {
        return RecipeMatch.of(block, 1);
    }

    public static RecipeMatch of(Block block, int matched) {
        return RecipeMatch.of(block, 1, matched);
    }

    public static RecipeMatch of(Block block, int amount, int matched) {
        return new Item(new ItemStack(block), amount, matched);
    }

    public static RecipeMatch of(ItemStack stack) {
        return RecipeMatch.of(stack, 1);
    }

    public static RecipeMatch of(ItemStack stack, int matched) {
        return RecipeMatch.of(stack, 1, matched);
    }

    public static RecipeMatch of(ItemStack stack, int amount, int matched) {
        return new Item(stack.copy(), amount, matched);
    }

    public static RecipeMatch ofNBT(ItemStack stack) {
        return RecipeMatch.ofNBT(stack, 1);
    }

    public static RecipeMatch ofNBT(ItemStack stack, int matched) {
        return new ItemCombination(matched, stack);
    }

    public static void removeMatch(ItemStack[] stacks, Match match) {
        block0: for (ItemStack stack : match.stacks) {
            for (int i = 0; i < stacks.length; ++i) {
                if (!ItemStack.areItemsEqual((ItemStack)stack, (ItemStack)stacks[i]) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)stacks[i])) continue;
                if (stacks[i].stackSize < stack.stackSize) {
                    Mantle.logger.error("RecipeMatch has incorrect stacksize! {}", new Object[]{stacks[i].toString()});
                    continue block0;
                }
                stacks[i].stackSize -= stack.stackSize;
                if (stacks[i].stackSize != 0) continue block0;
                stacks[i] = null;
                continue block0;
            }
        }
    }

    public static class Match {
        public List<ItemStack> stacks;
        public int amount;

        public Match(List<ItemStack> stacks, int amount) {
            this.stacks = stacks;
            this.amount = amount;
        }
    }

    public static class Oredict
    extends RecipeMatch {
        private final List<ItemStack> oredictEntry;

        public Oredict(List<ItemStack> oredictEntry, int amountNeeded) {
            this(oredictEntry, amountNeeded, 1);
        }

        public Oredict(List<ItemStack> oredictEntry, int amountNeeded, int amountMatched) {
            super(amountMatched, amountNeeded);
            this.oredictEntry = oredictEntry;
        }

        public Oredict(String oredictEntry, int amountNeeded) {
            this(oredictEntry, amountNeeded, 1);
        }

        public Oredict(String oredictEntry, int amountNeeded, int amountMatched) {
            super(amountMatched, amountNeeded);
            this.oredictEntry = OreDictionary.getOres((String)oredictEntry);
        }

        @Override
        public List<ItemStack> getInputs() {
            return this.oredictEntry;
        }

        @Override
        public Match matches(ItemStack[] stacks) {
            LinkedList found = Lists.newLinkedList();
            int stillNeeded = this.amountNeeded;
            for (ItemStack ore : this.oredictEntry) {
                for (ItemStack stack : stacks) {
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false)) continue;
                    ItemStack copy = stack.copy();
                    copy.stackSize = Math.min(copy.stackSize, stillNeeded);
                    found.add(copy);
                    if ((stillNeeded -= copy.stackSize) > 0) continue;
                    return new Match(found, this.amountMatched);
                }
            }
            return null;
        }
    }

    public static class ItemCombination
    extends RecipeMatch {
        protected final ItemStack[] itemStacks;

        public ItemCombination(int amountMatched, ItemStack ... stacks) {
            super(amountMatched, 0);
            this.itemStacks = stacks;
        }

        @Override
        public List<ItemStack> getInputs() {
            return ImmutableList.copyOf((Object[])this.itemStacks);
        }

        @Override
        public Match matches(ItemStack[] stacks) {
            LinkedList found = Lists.newLinkedList();
            HashSet needed = Sets.newHashSet();
            for (int i = 0; i < this.itemStacks.length; ++i) {
                if (this.itemStacks[i] == null) continue;
                needed.add(i);
            }
            block1: for (ItemStack stack : stacks) {
                Iterator iter = needed.iterator();
                while (iter.hasNext()) {
                    int index = (Integer)iter.next();
                    ItemStack template = this.itemStacks[index];
                    if (!ItemStack.areItemsEqual((ItemStack)template, (ItemStack)stack) || !ItemStack.areItemStackTagsEqual((ItemStack)template, (ItemStack)stack)) continue;
                    ItemStack copy = stack.copy();
                    copy.stackSize = 1;
                    found.add(copy);
                    iter.remove();
                    continue block1;
                }
            }
            if (needed.isEmpty()) {
                return new Match(found, this.amountMatched);
            }
            return null;
        }
    }

    public static class Item
    extends RecipeMatch {
        private final ItemStack template;

        public Item(ItemStack template, int amountNeeded) {
            this(template, amountNeeded, 1);
        }

        public Item(ItemStack template, int amountNeeded, int amountMatched) {
            super(amountMatched, amountNeeded);
            this.template = template;
        }

        @Override
        public List<ItemStack> getInputs() {
            return ImmutableList.of((Object)this.template);
        }

        @Override
        public Match matches(ItemStack[] stacks) {
            LinkedList found = Lists.newLinkedList();
            int stillNeeded = this.amountNeeded;
            for (ItemStack stack : stacks) {
                if (!OreDictionary.itemMatches((ItemStack)this.template, (ItemStack)stack, (boolean)false)) continue;
                ItemStack copy = stack.copy();
                copy.stackSize = Math.min(copy.stackSize, stillNeeded);
                found.add(copy);
                if ((stillNeeded -= copy.stackSize) > 0) continue;
                return new Match(found, this.amountMatched);
            }
            return null;
        }
    }
}

