/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

@SideOnly(value=Side.CLIENT)
public class ElementItem
extends SizedBookElement {
    public static final int ITEM_SIZE_HARDCODED = 16;
    public static final int ITEM_SWITCH_TICKS = 90;
    public ItemStack[] itemCycle;
    public float scale;
    public String action;
    public List<String> tooltip;
    public int renderTick = 0;
    public int currentItem = 0;

    public ElementItem(int x, int y, float scale, Item item) {
        this(x, y, scale, new ItemStack(item));
    }

    public ElementItem(int x, int y, float scale, Block item) {
        this(x, y, scale, new ItemStack(item));
    }

    public ElementItem(int x, int y, float scale, ItemStack item) {
        this(x, y, scale, new ItemStack[]{item});
    }

    public ElementItem(int x, int y, float scale, Collection<ItemStack> itemCycle) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[itemCycle.size()]));
    }

    public ElementItem(int x, int y, float scale, Collection<ItemStack> itemCycle, String action) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[itemCycle.size()]), action);
    }

    public ElementItem(int x, int y, float scale, ItemStack ... itemCycle) {
        this(x, y, scale, itemCycle, (String)null);
    }

    public ElementItem(int x, int y, float scale, ItemStack[] itemCycle, String action) {
        super(x, y, MathHelper.floor((float)(16.0f * scale)), MathHelper.floor((float)(16.0f * scale)));
        this.itemCycle = itemCycle;
        this.scale = scale;
        this.action = action;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        ++this.renderTick;
        if (this.renderTick > 90) {
            this.renderTick = 0;
            ++this.currentItem;
            if (this.currentItem >= this.itemCycle.length) {
                this.currentItem = 0;
            }
        }
        RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)this.x, (float)this.y, (float)0.0f);
        GlStateManager.scale((float)this.scale, (float)this.scale, (float)1.0f);
        if (this.currentItem < this.itemCycle.length) {
            this.mc.getRenderItem().renderItemAndEffectIntoGUI(this.itemCycle[this.currentItem], 0, 0);
        }
        GlStateManager.popMatrix();
        RenderHelper.disableStandardItemLighting();
    }

    @Override
    public void drawOverlay(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.length) {
            if (this.tooltip != null) {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, fontRenderer);
            } else {
                this.renderToolTip(fontRenderer, this.itemCycle[this.currentItem], mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.length) {
            if (this.action != null) {
                StringActionProcessor.process(this.action, this.parent);
            } else {
                this.parent.itemClicked(this.itemCycle[this.currentItem]);
            }
        }
    }
}

