/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.LocUtils;

public class ItemBlockMeta
extends ItemColored {
    protected IProperty mappingProperty;

    public ItemBlockMeta(Block block) {
        super(block, true);
    }

    @Nonnull
    public String getUnlocalizedName(@Nonnull ItemStack stack) {
        if (this.mappingProperty == null) {
            return super.getUnlocalizedName(stack);
        }
        IBlockState state = this.block.getStateFromMeta(stack.getMetadata());
        String name = state.getValue(this.mappingProperty).toString().toLowerCase(Locale.US);
        return super.getUnlocalizedName(stack) + "." + name;
    }

    public static void setMappingProperty(Block block, IProperty<?> property) {
        ((ItemBlockMeta)Item.getItemFromBlock((Block)block)).mappingProperty = property;
    }

    public void addInformation(@Nonnull ItemStack stack, @Nonnull EntityPlayer playerIn, @Nonnull List<String> tooltip, boolean advanced) {
        if (I18n.canTranslate((String)(this.getUnlocalizedName(stack) + ".tooltip"))) {
            tooltip.addAll(LocUtils.getTooltips(TextFormatting.GRAY.toString() + LocUtils.translateRecursive(this.getUnlocalizedName(stack) + ".tooltip", new Object[0])));
        } else if (I18n.canTranslate((String)(super.getUnlocalizedName(stack) + ".tooltip"))) {
            tooltip.addAll(LocUtils.getTooltips(TextFormatting.GRAY.toString() + LocUtils.translateRecursive(super.getUnlocalizedName(stack) + ".tooltip", new Object[0])));
        }
        super.addInformation(stack, playerIn, tooltip, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        ItemBlockMeta item = this;
        ResourceLocation loc = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)this.block);
        for (Comparable o : this.mappingProperty.getAllowedValues()) {
            int meta = this.block.getMetaFromState(this.block.getDefaultState().withProperty(this.mappingProperty, o));
            String name = this.mappingProperty.getName(o);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, this.mappingProperty.getName() + "=" + name));
        }
    }
}

