/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.util.IngredientUtil;

public class IngredientBlacklist
implements IIngredientBlacklist {
    private final IIngredientRegistry ingredientRegistry;
    private final Set<String> ingredientBlacklist = new HashSet<String>();

    public IngredientBlacklist(IIngredientRegistry ingredientRegistry) {
        this.ingredientRegistry = ingredientRegistry;
    }

    @Override
    public <V> void addIngredientToBlacklist(V ingredient) {
        Preconditions.checkNotNull(ingredient, (Object)"Null ingredient");
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        String uniqueName = ingredientHelper.getUniqueId(ingredient);
        this.ingredientBlacklist.add(uniqueName);
    }

    @Override
    public <V> void removeIngredientFromBlacklist(V ingredient) {
        Preconditions.checkNotNull(ingredient, (Object)"Null ingredient");
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        String uniqueName = ingredientHelper.getUniqueId(ingredient);
        this.ingredientBlacklist.remove(uniqueName);
    }

    @Override
    public <V> boolean isIngredientBlacklisted(V ingredient) {
        Preconditions.checkNotNull(ingredient, (Object)"Null ingredient");
        if (this.isIngredientBlacklistedByApi(ingredient)) {
            return true;
        }
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        return Config.isIngredientOnConfigBlacklist(ingredient, ingredientHelper);
    }

    public <V> boolean isIngredientBlacklistedByApi(V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        List<String> uids = IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient);
        for (String uid : uids) {
            if (!this.ingredientBlacklist.contains(uid)) continue;
            return true;
        }
        return false;
    }
}

