/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.StackHelper;
import mezz.jei.util.color.ColorGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;

    public ItemStackHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    @Override
    public List<ItemStack> expandSubtypes(List<ItemStack> contained) {
        return this.stackHelper.getAllSubtypes(contained);
    }

    @Override
    @Nullable
    public ItemStack getMatch(Iterable<ItemStack> ingredients, ItemStack toMatch) {
        return this.stackHelper.containsStack(ingredients, toMatch);
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        String displayName = ingredient.func_82833_r();
        if (displayName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new NullPointerException("No display name for itemStack. " + ingredientInfo);
        }
        return displayName;
    }

    @Override
    public String getUniqueId(ItemStack ingredient) {
        return this.stackHelper.getUniqueIdentifierForStack(ingredient);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, StackHelper.UidMode.WILDCARD);
    }

    @Override
    public String getModId(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        if (item == null) {
            throw new NullPointerException("Null item in ItemStack");
        }
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new NullPointerException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110624_b();
    }

    @Override
    public Iterable<Color> getColors(ItemStack ingredient) {
        return ColorGetter.getColors(ingredient, 2);
    }

    @Override
    public String getErrorInfo(ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }
}

