/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.LocalizedConfiguration;
import mezz.jei.config.OverlayToggleEvent;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import mezz.jei.util.color.ColorGetter;
import mezz.jei.util.color.ColorNamer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Config {
    private static final String configKeyPrefix = "config.jei";
    public static final String CATEGORY_SEARCH = "search";
    public static final String CATEGORY_ADVANCED = "advanced";
    public static final String CATEGORY_SEARCH_COLORS = "searchColors";
    @Nullable
    private static LocalizedConfiguration config;
    @Nullable
    private static Configuration worldConfig;
    @Nullable
    private static LocalizedConfiguration itemBlacklistConfig;
    @Nullable
    private static LocalizedConfiguration searchColorsConfig;
    private static boolean debugModeEnabled;
    private static boolean centerSearchBarEnabled;
    private static final String defaultModNameFormatFriendly = "blue italic";
    private static String modNameFormat;
    private static final SearchMode defaultModNameSearchMode;
    private static final SearchMode defaultTooltipSearchMode;
    private static final SearchMode defaultOreDictSearchMode;
    private static final SearchMode defaultCreativeTabSearchMode;
    private static final SearchMode defaultColorSearchMode;
    private static SearchMode modNameSearchMode;
    private static SearchMode tooltipSearchMode;
    private static SearchMode oreDictSearchMode;
    private static SearchMode creativeTabSearchMode;
    private static SearchMode colorSearchMode;
    private static final boolean defaultOverlayEnabled = true;
    private static final boolean defaultCheatItemsEnabled = false;
    private static final boolean defaultEditModeEnabled = false;
    private static final String defaultFilterText = "";
    private static boolean overlayEnabled;
    private static boolean cheatItemsEnabled;
    private static boolean editModeEnabled;
    private static String filterText;
    private static final Set<String> itemBlacklist;
    private static final String[] defaultItemBlacklist;

    private Config() {
    }

    public static boolean isOverlayEnabled() {
        return overlayEnabled;
    }

    public static void toggleOverlayEnabled() {
        boolean bl = overlayEnabled = !overlayEnabled;
        if (worldConfig != null) {
            String worldCategory = SessionData.getWorldUid();
            Property property = worldConfig.get(worldCategory, "overlayEnabled", overlayEnabled);
            property.set(overlayEnabled);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new OverlayToggleEvent(overlayEnabled));
    }

    public static boolean isCheatItemsEnabled() {
        return cheatItemsEnabled;
    }

    public static void toggleCheatItemsEnabled() {
        Config.setCheatItemsEnabled(!cheatItemsEnabled);
    }

    public static void setCheatItemsEnabled(boolean value) {
        if (cheatItemsEnabled != value) {
            cheatItemsEnabled = value;
            if (worldConfig != null) {
                String worldCategory = SessionData.getWorldUid();
                Property property = worldConfig.get(worldCategory, "cheatItemsEnabled", cheatItemsEnabled);
                property.set(cheatItemsEnabled);
                if (worldConfig.hasChanged()) {
                    worldConfig.save();
                }
            }
            if (cheatItemsEnabled && SessionData.isJeiOnServer()) {
                JustEnoughItems.getProxy().sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    public static boolean isEditModeEnabled() {
        return editModeEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return debugModeEnabled;
    }

    public static boolean isDeleteItemsInCheatModeActive() {
        return cheatItemsEnabled && SessionData.isJeiOnServer();
    }

    public static boolean isCenterSearchBarEnabled() {
        return centerSearchBarEnabled;
    }

    public static String getModNameFormat() {
        return modNameFormat;
    }

    public static SearchMode getModNameSearchMode() {
        return modNameSearchMode;
    }

    public static SearchMode getTooltipSearchMode() {
        return tooltipSearchMode;
    }

    public static SearchMode getOreDictSearchMode() {
        return oreDictSearchMode;
    }

    public static SearchMode getCreativeTabSearchMode() {
        return creativeTabSearchMode;
    }

    public static SearchMode getColorSearchMode() {
        return colorSearchMode;
    }

    public static boolean setFilterText(String filterText) {
        String lowercaseFilterText = filterText.toLowerCase();
        if (Config.filterText.equals(lowercaseFilterText)) {
            return false;
        }
        Config.filterText = lowercaseFilterText;
        return true;
    }

    public static String getFilterText() {
        return filterText;
    }

    public static void saveFilterText() {
        if (worldConfig != null) {
            String worldCategory = SessionData.getWorldUid();
            Property property = worldConfig.get(worldCategory, "filterText", defaultFilterText);
            property.set(filterText);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
    }

    @Nullable
    public static LocalizedConfiguration getConfig() {
        return config;
    }

    @Nullable
    public static Configuration getWorldConfig() {
        return worldConfig;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        File oldItemBlacklistConfigFile;
        File jeiConfigurationDir = new File(event.getModConfigurationDirectory(), "JEI");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    Log.error("Could not create config directory {}", jeiConfigurationDir);
                    return;
                }
            }
            catch (SecurityException e) {
                Log.error("Could not create config directory {}", jeiConfigurationDir, e);
                return;
            }
        }
        File configFile = new File(jeiConfigurationDir, "jei.cfg");
        File itemBlacklistConfigFile = new File(jeiConfigurationDir, "itemBlacklist.cfg");
        File searchColorsConfigFile = new File(jeiConfigurationDir, "searchColors.cfg");
        File worldConfigFile = new File(jeiConfigurationDir, "worldSettings.cfg");
        worldConfig = new Configuration(worldConfigFile, "0.1.0");
        File oldConfigFile = event.getSuggestedConfigurationFile();
        if (oldConfigFile.exists()) {
            try {
                if (!oldConfigFile.renameTo(configFile)) {
                    Log.error("Could not move old config file {}", oldConfigFile);
                }
            }
            catch (SecurityException e) {
                Log.error("Could not move old config file {}", oldConfigFile, e);
            }
        }
        if ((oldItemBlacklistConfigFile = new File(event.getModConfigurationDirectory(), "JEI-itemBlacklist.cfg")).exists()) {
            try {
                if (!oldItemBlacklistConfigFile.renameTo(itemBlacklistConfigFile)) {
                    Log.error("Could not move old config file {}", oldItemBlacklistConfigFile);
                }
            }
            catch (SecurityException e) {
                Log.error("Could not move old config file {}", oldItemBlacklistConfigFile, e);
            }
        }
        config = new LocalizedConfiguration(configKeyPrefix, configFile, "0.2.0");
        itemBlacklistConfig = new LocalizedConfiguration(configKeyPrefix, itemBlacklistConfigFile, "0.1.0");
        searchColorsConfig = new LocalizedConfiguration(configKeyPrefix, searchColorsConfigFile, "0.1.0");
        Config.syncConfig();
        Config.syncItemBlacklistConfig();
        Config.syncSearchColorsConfig();
    }

    public static boolean syncAllConfig() {
        boolean needsReload = false;
        if (Config.syncConfig()) {
            needsReload = true;
        }
        if (Config.syncItemBlacklistConfig()) {
            needsReload = true;
        }
        if (Config.syncWorldConfig()) {
            needsReload = true;
        }
        if (Config.syncSearchColorsConfig()) {
            needsReload = true;
        }
        return needsReload;
    }

    private static boolean syncConfig() {
        boolean configChanged;
        ConfigCategory interfaceCategory;
        ConfigCategory addonsCategory;
        if (config == null) {
            return false;
        }
        boolean needsReload = false;
        config.addCategory(CATEGORY_SEARCH);
        config.addCategory(CATEGORY_ADVANCED);
        ConfigCategory modeCategory = config.getCategory("mode");
        if (modeCategory != null) {
            config.removeCategory(modeCategory);
        }
        if ((addonsCategory = config.getCategory("addons")) != null) {
            config.removeCategory(addonsCategory);
        }
        if ((interfaceCategory = config.getCategory("interface")) != null) {
            config.removeCategory(interfaceCategory);
        }
        ConfigCategory searchCategory = config.getCategory(CATEGORY_SEARCH);
        searchCategory.remove((Object)"atPrefixRequiredForModName");
        searchCategory.remove((Object)"prefixRequiredForTooltipSearch");
        searchCategory.remove((Object)"prefixRequiredForOreDictSearch");
        searchCategory.remove((Object)"prefixRequiredForCreativeTabSearch");
        searchCategory.remove((Object)"prefixRequiredForColorSearch");
        Enum[] searchModes = SearchMode.values();
        modNameSearchMode = (SearchMode)config.getEnum("modNameSearchMode", CATEGORY_SEARCH, defaultModNameSearchMode, searchModes);
        tooltipSearchMode = (SearchMode)config.getEnum("tooltipSearchMode", CATEGORY_SEARCH, defaultTooltipSearchMode, searchModes);
        oreDictSearchMode = (SearchMode)config.getEnum("oreDictSearchMode", CATEGORY_SEARCH, defaultOreDictSearchMode, searchModes);
        creativeTabSearchMode = (SearchMode)config.getEnum("creativeTabSearchMode", CATEGORY_SEARCH, defaultCreativeTabSearchMode, searchModes);
        colorSearchMode = (SearchMode)config.getEnum("colorSearchMode", CATEGORY_SEARCH, defaultColorSearchMode, searchModes);
        if (config.getCategory(CATEGORY_SEARCH).hasChanged()) {
            needsReload = true;
        }
        ConfigCategory categoryAdvanced = config.getCategory(CATEGORY_ADVANCED);
        categoryAdvanced.remove((Object)"nbtKeyIgnoreList");
        categoryAdvanced.remove((Object)"deleteItemsInCheatModeEnabled");
        categoryAdvanced.remove((Object)"hideLaggyModelsEnabled");
        categoryAdvanced.remove((Object)"hideMissingModelsEnabled");
        categoryAdvanced.remove((Object)"debugItemEnabled");
        categoryAdvanced.remove((Object)"colorSearchEnabled");
        centerSearchBarEnabled = config.getBoolean(CATEGORY_ADVANCED, "centerSearchBarEnabled", centerSearchBarEnabled);
        EnumSet<TextFormatting> validFormatting = EnumSet.allOf(TextFormatting.class);
        validFormatting.remove(TextFormatting.RESET);
        String[] validValues = new String[validFormatting.size()];
        int i = 0;
        for (TextFormatting formatting : validFormatting) {
            validValues[i] = formatting.func_96297_d().toLowerCase(Locale.ENGLISH);
            ++i;
        }
        String modNameFormatFriendly = config.getString("modNameFormat", CATEGORY_ADVANCED, defaultModNameFormatFriendly, validValues);
        modNameFormat = Config.parseFriendlyModNameFormat(modNameFormatFriendly);
        debugModeEnabled = config.getBoolean(CATEGORY_ADVANCED, "debugModeEnabled", debugModeEnabled);
        Property property = config.get(CATEGORY_ADVANCED, "debugModeEnabled", debugModeEnabled);
        property.setShowInGui(false);
        if (itemBlacklistConfig != null && config.hasKey(CATEGORY_ADVANCED, "itemBlacklist")) {
            Property oldItemBlacklistProperty = config.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
            String[] itemBlacklistArray = oldItemBlacklistProperty.getStringList();
            Property newItemBlacklistProperty = itemBlacklistConfig.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
            newItemBlacklistProperty.set(itemBlacklistArray);
            categoryAdvanced.remove((Object)"itemBlacklist");
        }
        if (configChanged = config.hasChanged()) {
            config.save();
        }
        return needsReload;
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        String format = defaultFilterText;
        if (formatWithEnumNames.isEmpty()) {
            return format;
        }
        for (String string : strings = formatWithEnumNames.split(" ")) {
            TextFormatting valueByName = TextFormatting.func_96300_b((String)string);
            if (valueByName != null) {
                format = format + valueByName.toString();
                continue;
            }
            Log.error("Invalid format: {}", string);
        }
        return format;
    }

    private static boolean syncItemBlacklistConfig() {
        if (itemBlacklistConfig == null) {
            return false;
        }
        itemBlacklistConfig.addCategory(CATEGORY_ADVANCED);
        String[] itemBlacklistArray = itemBlacklistConfig.getStringList("itemBlacklist", CATEGORY_ADVANCED, defaultItemBlacklist);
        itemBlacklist.clear();
        Collections.addAll(itemBlacklist, itemBlacklistArray);
        boolean configChanged = itemBlacklistConfig.hasChanged();
        if (configChanged) {
            itemBlacklistConfig.save();
        }
        return configChanged;
    }

    public static boolean syncWorldConfig() {
        if (worldConfig == null) {
            return false;
        }
        boolean needsReload = false;
        String worldCategory = SessionData.getWorldUid();
        Property property = worldConfig.get(worldCategory, "overlayEnabled", true);
        property.setLanguageKey("config.jei.interface.overlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.overlayEnabled.comment"));
        property.setShowInGui(false);
        overlayEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "cheatItemsEnabled", false);
        property.setLanguageKey("config.jei.mode.cheatItemsEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.cheatItemsEnabled.comment"));
        cheatItemsEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "editEnabled", false);
        property.setLanguageKey("config.jei.mode.editEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.editEnabled.comment"));
        editModeEnabled = property.getBoolean();
        if (property.hasChanged()) {
            needsReload = true;
        }
        property = worldConfig.get(worldCategory, "filterText", defaultFilterText);
        property.setShowInGui(false);
        filterText = property.getString();
        boolean configChanged = worldConfig.hasChanged();
        if (configChanged) {
            worldConfig.save();
        }
        return needsReload;
    }

    private static boolean syncSearchColorsConfig() {
        if (searchColorsConfig == null) {
            return false;
        }
        searchColorsConfig.addCategory(CATEGORY_SEARCH_COLORS);
        String[] searchColorDefaults = ColorGetter.getColorDefaults();
        String[] searchColors = searchColorsConfig.getStringList(CATEGORY_SEARCH_COLORS, CATEGORY_SEARCH_COLORS, searchColorDefaults);
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String entry : searchColors) {
            String[] values = entry.split(":");
            if (values.length != 2) {
                Log.error("Invalid format for searchColor entry: {}", entry);
                continue;
            }
            try {
                String name = values[0];
                int colorValue = Integer.decode("0x" + values[1]);
                Color color = new Color(colorValue);
                searchColorsMapBuilder.put((Object)color, (Object)name);
            }
            catch (NumberFormatException e) {
                Log.error("Invalid number format for searchColor entry: {}", entry, e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Color, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
        boolean configChanged = searchColorsConfig.hasChanged();
        if (configChanged) {
            searchColorsConfig.save();
        }
        return configChanged;
    }

    private static boolean updateBlacklist() {
        if (itemBlacklistConfig == null) {
            return false;
        }
        Property property = itemBlacklistConfig.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
        String[] currentBlacklist = itemBlacklist.toArray(new String[itemBlacklist.size()]);
        property.set(currentBlacklist);
        boolean changed = itemBlacklistConfig.hasChanged();
        if (changed) {
            itemBlacklistConfig.save();
        }
        return changed;
    }

    public static <V> void addIngredientToConfigBlacklist(V itemStack, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(itemStack, blacklistType, ingredientHelper);
        if (itemBlacklist.add(uid)) {
            Config.updateBlacklist();
        }
    }

    public static <V> void removeIngredientFromConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        if (itemBlacklist.remove(uid)) {
            Config.updateBlacklist();
        }
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!Config.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return itemBlacklist.contains(uid);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        switch (blacklistType) {
            case ITEM: {
                return ingredientHelper.getUniqueId(ingredient);
            }
            case WILDCARD: {
                return ingredientHelper.getWildcardId(ingredient);
            }
            case MOD_ID: {
                return ingredientHelper.getModId(ingredient);
            }
        }
        return defaultFilterText;
    }

    static {
        debugModeEnabled = false;
        centerSearchBarEnabled = false;
        modNameFormat = Config.parseFriendlyModNameFormat(defaultModNameFormatFriendly);
        defaultModNameSearchMode = SearchMode.REQUIRE_PREFIX;
        defaultTooltipSearchMode = SearchMode.ENABLED;
        defaultOreDictSearchMode = SearchMode.REQUIRE_PREFIX;
        defaultCreativeTabSearchMode = SearchMode.REQUIRE_PREFIX;
        defaultColorSearchMode = SearchMode.DISABLED;
        modNameSearchMode = defaultModNameSearchMode;
        tooltipSearchMode = defaultTooltipSearchMode;
        oreDictSearchMode = defaultOreDictSearchMode;
        creativeTabSearchMode = defaultCreativeTabSearchMode;
        colorSearchMode = defaultColorSearchMode;
        overlayEnabled = true;
        cheatItemsEnabled = false;
        editModeEnabled = false;
        filterText = defaultFilterText;
        itemBlacklist = new HashSet<String>();
        defaultItemBlacklist = new String[0];
    }

    public static enum IngredientBlacklistType {
        ITEM,
        WILDCARD,
        MOD_ID;

        public static final IngredientBlacklistType[] VALUES;

        static {
            VALUES = IngredientBlacklistType.values();
        }
    }

    public static enum SearchMode {
        ENABLED,
        REQUIRE_PREFIX,
        DISABLED;

    }
}

