/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.config.Constants;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import mezz.jei.plugins.vanilla.furnace.FurnaceRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.util.ResourceLocation;

public class FurnaceFuelCategory
extends FurnaceRecipeCategory<FuelRecipe> {
    private final IDrawable background;
    private final IDrawable flame;
    private final String localizedName;

    public FurnaceFuelCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(this.backgroundLocation, 55, 38, 18, 32, 0, 0, 0, 80);
        ResourceLocation recipeBackgroundResource = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground2.png");
        this.flame = guiHelper.createDrawable(recipeBackgroundResource, 215, 0, 14, 14);
        this.localizedName = Translator.translateToLocal("gui.jei.category.fuel");
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public String getUid() {
        return "minecraft.fuel";
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return this.flame;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, FuelRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(1, true, 0, 14);
        guiItemStacks.set(ingredients);
    }
}

