/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients;

import com.google.common.base.Objects;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.util.color.ColorGetter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackHelper
implements IIngredientHelper<FluidStack> {
    @Override
    public List<FluidStack> expandSubtypes(List<FluidStack> contained) {
        return contained;
    }

    @Override
    @Nullable
    public FluidStack getMatch(Iterable<FluidStack> ingredients, FluidStack toMatch) {
        for (FluidStack fluidStack : ingredients) {
            if (toMatch.getFluid() != fluidStack.getFluid()) continue;
            return fluidStack;
        }
        return null;
    }

    @Override
    public String getDisplayName(FluidStack ingredient) {
        return ingredient.getLocalizedName();
    }

    @Override
    public String getUniqueId(FluidStack ingredient) {
        if (ingredient.tag != null) {
            return "fluid:" + ingredient.getFluid().getName() + ":" + ingredient.tag;
        }
        return "fluid:" + ingredient.getFluid().getName();
    }

    @Override
    public String getWildcardId(FluidStack ingredient) {
        return this.getUniqueId(ingredient);
    }

    @Override
    public String getModId(FluidStack ingredient) {
        String defaultFluidName = FluidRegistry.getDefaultFluidName((Fluid)ingredient.getFluid());
        if (defaultFluidName == null) {
            return "";
        }
        ResourceLocation fluidResourceName = new ResourceLocation(defaultFluidName);
        return fluidResourceName.func_110624_b();
    }

    @Override
    public Iterable<Color> getColors(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        if (fluidStill != null) {
            TextureAtlasSprite fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
            int renderColor = ingredient.getFluid().getColor(ingredient);
            return ColorGetter.getColors(fluidStillSprite, renderColor, 1);
        }
        return Collections.emptyList();
    }

    @Override
    public String getErrorInfo(FluidStack ingredient) {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(FluidStack.class);
        Fluid fluid = ingredient.getFluid();
        if (fluid != null) {
            toStringHelper.add("Fluid", (Object)fluid.getLocalizedName(ingredient));
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", ingredient.amount);
        if (ingredient.tag != null) {
            toStringHelper.add("Tag", (Object)ingredient.tag);
        }
        return toStringHelper.toString();
    }
}

