/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BookmarkButton
extends GuiIconToggleButton {
    private final BookmarkOverlay bookmarkOverlay;
    private final BookmarkList bookmarkList;
    private final IWorldConfig worldConfig;

    public static BookmarkButton create(BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, Textures textures, IWorldConfig worldConfig) {
        IDrawableStatic offIcon = textures.getBookmarkButtonDisabledIcon();
        IDrawableStatic onIcon = textures.getBookmarkButtonEnabledIcon();
        return new BookmarkButton(offIcon, onIcon, bookmarkOverlay, bookmarkList, worldConfig);
    }

    private BookmarkButton(IDrawable offIcon, IDrawable onIcon, BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IWorldConfig worldConfig) {
        super(offIcon, onIcon);
        this.bookmarkOverlay = bookmarkOverlay;
        this.bookmarkList = bookmarkList;
        this.worldConfig = worldConfig;
    }

    @Override
    protected void getTooltips(List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.bookmarks"));
        KeyBinding bookmarkKey = KeyBindings.bookmark;
        if (bookmarkKey.getKey().func_197937_c() == -1) {
            TranslationTextComponent noKey = new TranslationTextComponent("jei.tooltip.bookmarks.usage.nokey");
            tooltip.add((ITextComponent)noKey.func_240699_a_(TextFormatting.RED));
        } else if (!this.bookmarkOverlay.hasRoom()) {
            TranslationTextComponent notEnoughSpace = new TranslationTextComponent("jei.tooltip.bookmarks.not.enough.space");
            tooltip.add((ITextComponent)notEnoughSpace.func_240699_a_(TextFormatting.GOLD));
        } else {
            TranslationTextComponent key = new TranslationTextComponent("jei.tooltip.bookmarks.usage.key", new Object[]{new TranslationTextComponent(bookmarkKey.func_197982_m())});
            tooltip.add((ITextComponent)key.func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarkOverlay.isListDisplayed();
    }

    @Override
    protected boolean onMouseClicked(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        if (!this.bookmarkList.isEmpty() && this.bookmarkOverlay.hasRoom()) {
            if (!clickState.isSimulate()) {
                this.worldConfig.toggleBookmarkEnabled();
            }
            return true;
        }
        return false;
    }
}

