/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.CategoryRecipeValidator;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.item.crafting.StonecuttingRecipe;

public final class VanillaRecipes {
    private final RecipeManager recipeManager;

    public VanillaRecipes() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ErrorUtil.checkNotNull(world, "minecraft world");
        this.recipeManager = world.func_199532_z();
    }

    public List<ICraftingRecipe> getCraftingRecipes(IRecipeCategory<ICraftingRecipe> craftingCategory) {
        CategoryRecipeValidator<ICraftingRecipe> validator = new CategoryRecipeValidator<ICraftingRecipe>(craftingCategory, 9);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_222149_a, validator);
    }

    public List<StonecuttingRecipe> getStonecuttingRecipes(IRecipeCategory<StonecuttingRecipe> stonecuttingCategory) {
        CategoryRecipeValidator<StonecuttingRecipe> validator = new CategoryRecipeValidator<StonecuttingRecipe>(stonecuttingCategory, 1);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_222154_f, validator);
    }

    public List<FurnaceRecipe> getFurnaceRecipes(IRecipeCategory<FurnaceRecipe> furnaceCategory) {
        CategoryRecipeValidator<FurnaceRecipe> validator = new CategoryRecipeValidator<FurnaceRecipe>(furnaceCategory, 1);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_222150_b, validator);
    }

    public List<SmokingRecipe> getSmokingRecipes(IRecipeCategory<SmokingRecipe> smokingCategory) {
        CategoryRecipeValidator<SmokingRecipe> validator = new CategoryRecipeValidator<SmokingRecipe>(smokingCategory, 1);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_222152_d, validator);
    }

    public List<BlastingRecipe> getBlastingRecipes(IRecipeCategory<BlastingRecipe> blastingCategory) {
        CategoryRecipeValidator<BlastingRecipe> validator = new CategoryRecipeValidator<BlastingRecipe>(blastingCategory, 1);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_222151_c, validator);
    }

    public List<CampfireCookingRecipe> getCampfireCookingRecipes(IRecipeCategory<CampfireCookingRecipe> campfireCategory) {
        CategoryRecipeValidator<CampfireCookingRecipe> validator = new CategoryRecipeValidator<CampfireCookingRecipe>(campfireCategory, 1);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_222153_e, validator);
    }

    public List<SmithingRecipe> getSmithingRecipes(IRecipeCategory<SmithingRecipe> smithingCategory) {
        CategoryRecipeValidator<SmithingRecipe> validator = new CategoryRecipeValidator<SmithingRecipe>(smithingCategory, 0);
        return VanillaRecipes.getValidRecipes(this.recipeManager, IRecipeType.field_234827_g_, validator);
    }

    private static <C extends IInventory, T extends IRecipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType) {
        Map recipes = recipeManager.func_215366_a(recipeType);
        return recipes.values();
    }

    private static <C extends IInventory, T extends IRecipe<C>> List<T> getValidRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return VanillaRecipes.getRecipes(recipeManager, recipeType).stream().filter(validator::isRecipeValid).collect(Collectors.toList());
    }
}

