/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class IngredientInfoRecipe<T> {
    private static final int lineSpacing = 2;
    private final List<ITextProperties> description;
    private final List<T> ingredients;
    private final IIngredientType<T> ingredientType;

    @Deprecated
    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, String ... descriptionKeys) {
        ITextComponent[] descriptionComponents = new ITextComponent[descriptionKeys.length];
        for (int i = 0; i < descriptionKeys.length; ++i) {
            String descriptionKey = descriptionKeys[i];
            descriptionComponents[i] = new TranslationTextComponent(descriptionKey);
        }
        return IngredientInfoRecipe.create(ingredients, ingredientType, descriptionComponents);
    }

    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, ITextComponent ... descriptionComponents) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<ITextProperties> descriptionLines = IngredientInfoRecipe.expandNewlines(descriptionComponents);
        descriptionLines = IngredientInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.font.getClass();
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<ITextProperties> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<T> recipe = new IngredientInfoRecipe<T>(ingredients, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<ITextProperties> expandNewlines(ITextComponent ... descriptionComponents) {
        ArrayList<ITextProperties> descriptionLinesExpanded = new ArrayList<ITextProperties>();
        for (ITextComponent descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.visit((ITextProperties.IStyledTextAcceptor)newLineTextAcceptor, Style.EMPTY);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<ITextProperties> wrapDescriptionLines(List<ITextProperties> descriptionLines) {
        Minecraft minecraft = Minecraft.getInstance();
        ArrayList<ITextProperties> descriptionLinesWrapped = new ArrayList<ITextProperties>();
        for (ITextProperties descriptionLine : descriptionLines) {
            List textLines = minecraft.font.getSplitter().splitLines(descriptionLine, 160, Style.EMPTY);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private IngredientInfoRecipe(List<T> ingredients, IIngredientType<T> ingredientType, List<ITextProperties> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientType = ingredientType;
    }

    public List<ITextProperties> getDescription() {
        return this.description;
    }

    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    public List<T> getIngredients() {
        return this.ingredients;
    }

    private static class ExpandNewLineTextAcceptor
    implements ITextProperties.IStyledTextAcceptor<Void> {
        private final List<ITextProperties> lines = new ArrayList<ITextProperties>();
        @Nullable
        private IFormattableTextComponent lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> accept(Style style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((ITextProperties)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add((ITextProperties)StringTextComponent.EMPTY);
                    continue;
                }
                StringTextComponent textComponent = new StringTextComponent(s);
                textComponent.setStyle(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.getStyle().isEmpty() && !this.lastComponent.getStyle().equals((Object)style)) {
                            this.lastComponent = new StringTextComponent("").append((ITextComponent)this.lastComponent);
                        }
                        this.lastComponent.append((ITextComponent)textComponent);
                        continue;
                    }
                    this.lines.add((ITextProperties)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((ITextProperties)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<ITextProperties> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((ITextProperties)this.lastComponent);
            }
        }
    }
}

