/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class ServerInfo {
    private static boolean jeiOnServer = false;
    @Nullable
    private static String worldUid = null;

    private ServerInfo() {
    }

    public static boolean isJeiOnServer() {
        return jeiOnServer;
    }

    public static void onConnectedToServer(boolean jeiOnServer) {
        ServerInfo.jeiOnServer = jeiOnServer;
        worldUid = null;
    }

    public static String getWorldUid(@Nullable NetworkManager networkManager) {
        if (worldUid == null) {
            if (networkManager == null) {
                worldUid = "default";
            } else if (networkManager.isMemoryConnection()) {
                MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
                if (minecraftServer != null) {
                    worldUid = minecraftServer.storageSource.getLevelId();
                }
            } else {
                ServerData serverData = Minecraft.getInstance().getCurrentServer();
                if (serverData != null) {
                    worldUid = serverData.ip + ' ' + serverData.name;
                }
            }
            if (worldUid == null) {
                worldUid = "default";
            }
            worldUid = "world" + worldUid.hashCode();
        }
        return worldUid;
    }
}

