/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum GiveMode {
    INVENTORY,
    MOUSE_PICKUP;


    @OnlyIn(value=Dist.CLIENT)
    public static int getStackSize(GiveMode giveMode, ItemStack itemStack, InputMappings.Input input) {
        switch (giveMode) {
            case INVENTORY: {
                if (input.getType() == InputMappings.Type.MOUSE && input.getValue() == 0) {
                    return itemStack.getMaxStackSize();
                }
                return 1;
            }
            case MOUSE_PICKUP: {
                boolean modifierActive = Screen.hasShiftDown() || Minecraft.getInstance().options.keyPickItem.isActiveAndMatches(input);
                return modifierActive ? itemStack.getMaxStackSize() : 1;
            }
        }
        throw new IllegalArgumentException("Unknown give mode: " + (Object)((Object)giveMode));
    }
}

