/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class JeiBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> ingredients;
    private final List<ItemStack> potionInputs;
    private final ItemStack potionOutput;
    private final BrewingRecipeUtil brewingRecipeUtil;
    private final List<List<ItemStack>> inputs;
    private final int hashCode;

    public JeiBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, BrewingRecipeUtil brewingRecipeUtil) {
        this.ingredients = ingredients;
        this.potionInputs = potionInputs;
        this.potionOutput = potionOutput;
        this.brewingRecipeUtil = brewingRecipeUtil;
        brewingRecipeUtil.addRecipe(potionInputs, potionOutput);
        this.inputs = new ArrayList<List<ItemStack>>();
        this.inputs.add(potionInputs);
        this.inputs.add(potionInputs);
        this.inputs.add(potionInputs);
        this.inputs.add(ingredients);
        ItemStack firstIngredient = ingredients.get(0);
        ItemStack firstInput = potionInputs.get(0);
        Potion typeIn = PotionUtils.getPotion((ItemStack)firstInput);
        Potion typeOut = PotionUtils.getPotion((ItemStack)potionOutput);
        this.hashCode = com.google.common.base.Objects.hashCode((Object[])new Object[]{firstInput.getItem(), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)typeIn), potionOutput.getItem(), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)typeOut), firstIngredient.getItem()});
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof JeiBrewingRecipe)) {
            return false;
        }
        JeiBrewingRecipe other = (JeiBrewingRecipe)obj;
        for (i = 0; i < this.potionInputs.size(); ++i) {
            ItemStack otherPotionInput;
            ItemStack potionInput = this.potionInputs.get(i);
            if (JeiBrewingRecipe.arePotionsEqual(potionInput, otherPotionInput = other.potionInputs.get(i))) continue;
            return false;
        }
        if (!JeiBrewingRecipe.arePotionsEqual(other.potionOutput, this.potionOutput)) {
            return false;
        }
        if (this.ingredients.size() != other.ingredients.size()) {
            return false;
        }
        for (i = 0; i < this.ingredients.size(); ++i) {
            if (ItemStack.matches((ItemStack)this.ingredients.get(i), (ItemStack)other.ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean arePotionsEqual(ItemStack potion1, ItemStack potion2) {
        if (potion1.getItem() != potion2.getItem()) {
            return false;
        }
        Potion type1 = PotionUtils.getPotion((ItemStack)potion1);
        Potion type2 = PotionUtils.getPotion((ItemStack)potion2);
        ResourceLocation key1 = type1.getRegistryName();
        ResourceLocation key2 = type2.getRegistryName();
        return Objects.equals(key1, key2);
    }

    @Override
    public int getBrewingSteps() {
        return this.brewingRecipeUtil.getBrewingSteps(this.potionOutput);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        Potion inputType = PotionUtils.getPotion((ItemStack)this.potionInputs.get(0));
        Potion outputType = PotionUtils.getPotion((ItemStack)this.potionOutput);
        return this.ingredients + " + [" + this.potionInputs.get(0).getItem() + " " + inputType.getName("") + "] = [" + this.potionOutput + " " + outputType.getName("") + "]";
    }
}

