/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting.replacers;

import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.potion.Effect;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public final class SuspiciousStewRecipeMaker {
    public static Stream<ICraftingRecipe> createRecipes() {
        String group = "jei.suspicious.stew";
        Ingredient brownMushroom = Ingredient.of((IItemProvider[])new IItemProvider[]{Blocks.BROWN_MUSHROOM.asItem()});
        Ingredient redMushroom = Ingredient.of((IItemProvider[])new IItemProvider[]{Blocks.RED_MUSHROOM.asItem()});
        Ingredient bowl = Ingredient.of((IItemProvider[])new IItemProvider[]{Items.BOWL});
        return BlockTags.SMALL_FLOWERS.getValues().stream().filter(FlowerBlock.class::isInstance).map(FlowerBlock.class::cast).map(flowerBlock -> {
            Ingredient flower = Ingredient.of((IItemProvider[])new IItemProvider[]{flowerBlock.asItem()});
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{brownMushroom, redMushroom, bowl, flower});
            ItemStack output = new ItemStack((IItemProvider)Items.SUSPICIOUS_STEW, 1);
            Effect mobeffect = flowerBlock.getSuspiciousStewEffect();
            SuspiciousStewItem.saveMobEffect((ItemStack)output, (Effect)mobeffect, (int)flowerBlock.getEffectDuration());
            ResourceLocation id = new ResourceLocation("minecraft", "jei.suspicious.stew." + flowerBlock.getDescriptionId());
            return new ShapelessRecipe(id, group, output, inputs);
        });
    }

    private SuspiciousStewRecipeMaker() {
    }
}

