/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.cooking.fuel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.plugins.vanilla.cooking.fuel.FuelRecipe;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FuelRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();

    private FuelRecipeMaker() {
    }

    public static List<FuelRecipe> getFuelRecipes(IIngredientManager ingredientManager, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        Collection<ItemStack> allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>();
        for (ItemStack stack : allItemStacks) {
            int burnTime = FuelRecipeMaker.getBurnTime(stack);
            if (burnTime <= 0) continue;
            fuelRecipes.add(new FuelRecipe(guiHelper, Collections.singleton(stack), burnTime));
        }
        return fuelRecipes;
    }

    private static int getBurnTime(ItemStack itemStack) {
        try {
            return ForgeHooks.getBurnTime((ItemStack)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
            return 0;
        }
    }
}

