/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.textures.Textures;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.TextFormatting;

public class ConfigButton
extends GuiIconToggleButton {
    private final IngredientListOverlay parent;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(IngredientListOverlay parent, IWorldConfig worldConfig) {
        Textures textures = Internal.getTextures();
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), parent, worldConfig);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, IngredientListOverlay parent, IWorldConfig worldConfig) {
        super(disabledIcon, enabledIcon);
        this.parent = parent;
        this.worldConfig = worldConfig;
    }

    @Override
    protected void getTooltips(List<String> tooltip) {
        tooltip.add(Translator.translateToLocal("jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            tooltip.add(TextFormatting.GOLD + Translator.translateToLocal("jei.tooltip.ingredient.list.disabled"));
            tooltip.add(TextFormatting.GOLD + Translator.translateToLocalFormatted("jei.tooltip.ingredient.list.disabled.how.to.fix", KeyBindings.toggleOverlay.func_197978_k()));
        } else if (!this.parent.isListDisplayed()) {
            tooltip.add(TextFormatting.GOLD + Translator.translateToLocal("jei.tooltip.not.enough.space"));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            tooltip.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.cheat.mode.button.enabled"));
            KeyBinding toggleCheatMode = KeyBindings.toggleCheatMode;
            if (toggleCheatMode.getKey().func_197937_c() != 0) {
                tooltip.add(TextFormatting.RED + Translator.translateToLocalFormatted("jei.tooltip.cheat.mode.how.to.disable.hotkey", toggleCheatMode.func_197978_k()));
            } else {
                String controlKeyLocalization = Translator.translateToLocal(Minecraft.field_142025_a ? "key.jei.ctrl.mac" : "key.jei.ctrl");
                tooltip.add(TextFormatting.RED + Translator.translateToLocalFormatted("jei.tooltip.cheat.mode.how.to.disable.no.hotkey", controlKeyLocalization));
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.worldConfig.isOverlayEnabled()) {
            long windowHandle = Minecraft.func_71410_x().field_195558_d.func_198092_i();
            if (InputMappings.func_216506_a((long)windowHandle, (int)341) || InputMappings.func_216506_a((long)windowHandle, (int)345)) {
                this.worldConfig.toggleCheatItemsEnabled();
            } else {
                Minecraft minecraft = Minecraft.func_71410_x();
                if (minecraft.field_71462_r != null) {
                    // empty if block
                }
            }
            return true;
        }
        return false;
    }
}

