/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.textures;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.ClientHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class JeiTextureMap
extends TextureMap {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation location;
    private final Deque<ResourceLocation> loadingSprites = new ArrayDeque<ResourceLocation>();
    private final Set<ResourceLocation> loadedSprites = new HashSet<ResourceLocation>();

    public JeiTextureMap(String basePathIn) {
        super(basePathIn);
        this.location = new ResourceLocation("jei", basePathIn);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void registerSprite(ResourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        this.field_195427_i.add(location);
    }

    public void func_195413_a(IResourceManager resourceManager) {
        this.func_147631_c();
        this.func_195421_b(resourceManager);
    }

    public void func_195421_b(IResourceManager manager) {
        this.func_147633_a(0);
        int i = Minecraft.func_71369_N();
        Stitcher stitcher = new Stitcher(i, i, 0, 0);
        this.func_195419_g();
        int j = Integer.MAX_VALUE;
        int k = 1;
        LOGGER.info("Max texture size: {}", (Object)i);
        this.loadedSprites.clear();
        for (ResourceLocation resourcelocation : Sets.newHashSet((Iterable)this.field_195427_i)) {
            if (this.field_94249_f.func_195668_m().equals((Object)resourcelocation)) continue;
            j = this.loadTexture(stitcher, manager, resourcelocation, j, k);
        }
        this.field_94249_f.func_147963_d(0);
        stitcher.func_110934_a(this.field_94249_f);
        stitcher.func_94305_f();
        LOGGER.info("Created: {}x{} {}-atlas", (Object)stitcher.func_110935_a(), (Object)stitcher.func_110936_b(), (Object)this.field_94254_c);
        TextureUtil.func_180600_a((int)this.func_110552_b(), (int)0, (int)stitcher.func_110935_a(), (int)stitcher.func_110936_b());
        for (TextureAtlasSprite textureatlassprite1 : stitcher.func_94309_g()) {
            this.field_94252_e.put(textureatlassprite1.func_195668_m(), textureatlassprite1);
            try {
                textureatlassprite1.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
                crashreportcategory.func_71507_a("Atlas path", (Object)this.field_94254_c);
                crashreportcategory.func_71507_a("Sprite", (Object)textureatlassprite1);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite1.func_130098_m()) continue;
            this.field_94258_i.add(textureatlassprite1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int loadTexture(Stitcher stitcher, IResourceManager manager, ResourceLocation resourcelocation, int j, int k) {
        if (this.loadedSprites.contains(resourcelocation)) {
            return j;
        }
        ResourceLocation resourcelocation1 = this.getSpritePath(resourcelocation);
        for (ResourceLocation loading : this.loadingSprites) {
            if (!resourcelocation1.equals((Object)loading)) continue;
            String error = "circular model dependencies, stack: [" + Joiner.on((String)", ").join(this.loadingSprites) + "]";
            ClientHooks.trackBrokenTexture((ResourceLocation)resourcelocation, (String)error);
        }
        this.loadingSprites.addLast(resourcelocation1);
        try {
            int n;
            Throwable throwable;
            IResource iresource;
            block32: {
                block33: {
                    TextureAtlasSprite textureatlassprite;
                    block29: {
                        int n2;
                        block30: {
                            block31: {
                                iresource = manager.func_199002_a(resourcelocation1);
                                throwable = null;
                                PngSizeInfo pngsizeinfo = new PngSizeInfo(iresource);
                                AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                                textureatlassprite = new TextureAtlasSprite(resourcelocation, pngsizeinfo, animationmetadatasection);
                                for (ResourceLocation dependency : textureatlassprite.getDependencies()) {
                                    if (!this.field_195427_i.contains(dependency)) {
                                        this.func_199362_a(manager, dependency);
                                    }
                                    j = this.loadTexture(stitcher, manager, dependency, j, k);
                                }
                                if (!textureatlassprite.hasCustomLoader(manager, resourcelocation)) break block29;
                                if (!textureatlassprite.load(manager, resourcelocation, this.field_94252_e::get)) break block29;
                                n2 = j;
                                if (iresource == null) break block30;
                                if (throwable == null) break block31;
                                try {
                                    iresource.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block30;
                            }
                            iresource.close();
                        }
                        return n2;
                    }
                    j = Math.min(j, Math.min(textureatlassprite.func_94211_a(), textureatlassprite.func_94216_b()));
                    int j1 = Math.min(Integer.lowestOneBit(textureatlassprite.func_94211_a()), Integer.lowestOneBit(textureatlassprite.func_94216_b()));
                    if (j1 < k) {
                        LOGGER.warn("Texture {} with size {}x{} will have visual artifacts at mip level {}, it can only support level {}.Please report to the mod author that the texture should be some multiple of 16x16.", (Object)resourcelocation1, (Object)textureatlassprite.func_94211_a(), (Object)textureatlassprite.func_94216_b(), (Object)MathHelper.func_151239_c((int)k), (Object)MathHelper.func_151239_c((int)j1));
                    }
                    if (this.func_195422_a(manager, textureatlassprite)) {
                        stitcher.func_110934_a(textureatlassprite);
                    }
                    n = j;
                    if (iresource == null) break block32;
                    if (throwable == null) break block33;
                    try {
                        iresource.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block32;
                }
                iresource.close();
            }
            return n;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (iresource != null) {
                            if (throwable != null) {
                                try {
                                    iresource.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                iresource.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (RuntimeException runtimeexception) {
                    ClientHooks.trackBrokenTexture((ResourceLocation)resourcelocation, (String)runtimeexception.getMessage());
                    int n3 = j;
                    return n3;
                }
                catch (IOException ioexception) {
                    ClientHooks.trackMissingTexture((ResourceLocation)resourcelocation);
                    int n4 = j;
                    return n4;
                }
            }
        }
        finally {
            this.loadingSprites.removeLast();
            this.field_195427_i.add(resourcelocation1);
        }
    }

    private ResourceLocation getSpritePath(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, location.func_110623_a(), ".png"));
    }
}

