/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.util.Translator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.HoverChecker;

public class ShapelessIcon {
    private static final int scale = 4;
    private final IDrawable icon = Internal.getTextures().getShapelessIcon();
    private final HoverChecker hoverChecker;

    public ShapelessIcon() {
        int iconBottom = this.icon.getHeight() / 4;
        int iconLeft = 116 - this.icon.getWidth() / 4;
        int iconRight = iconLeft + this.icon.getWidth() / 4;
        this.hoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight, 0);
    }

    public void draw(int recipeWidth) {
        int shapelessIconX = recipeWidth - this.icon.getWidth() / 4;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)shapelessIconX, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)1.0);
        this.icon.draw();
        GlStateManager.func_179121_F();
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(Translator.translateToLocal("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

