/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import javax.annotation.Nullable;
import javax.vecmath.Point2d;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;

public class GhostIngredientReturning<T> {
    private static final long DURATION_PER_SCREEN_WIDTH = 500L;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final Point2d start;
    private final Point2d end;
    private final long startTime;
    private final long duration;

    @Nullable
    public static <T> GhostIngredientReturning<T> create(GhostIngredientDrag<T> ghostIngredientDrag, double mouseX, double mouseY) {
        Rectangle2d origin = ghostIngredientDrag.getOrigin();
        if (origin != null) {
            IIngredientRenderer<T> ingredientRenderer = ghostIngredientDrag.getIngredientRenderer();
            T ingredient = ghostIngredientDrag.getIngredient();
            Point2d end = new Point2d((double)origin.func_199318_a(), (double)origin.func_199319_b());
            Point2d start = new Point2d(mouseX - 8.0, mouseY - 8.0);
            return new GhostIngredientReturning<T>(ingredientRenderer, ingredient, start, end);
        }
        return null;
    }

    private GhostIngredientReturning(IIngredientRenderer<T> ingredientRenderer, T ingredient, Point2d start, Point2d end) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.start = start;
        this.end = end;
        this.startTime = System.currentTimeMillis();
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen != null) {
            int width = currentScreen.field_146294_l;
            float durationPerPixel = 500.0f / (float)width;
            float distance = (float)start.distance(end);
            this.duration = Math.round(durationPerPixel * distance);
        } else {
            this.duration = Math.round(250.0f);
        }
    }

    public void drawItem(Minecraft minecraft) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        double percent = Math.min((double)elapsed / (double)this.duration, 1.0);
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        double x = this.start.x + (double)Math.round(dx * percent);
        double y = this.start.y + (double)Math.round(dy * percent);
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        itemRenderer.field_77023_b += 150.0f;
        this.ingredientRenderer.render((int)x, (int)y, this.ingredient);
        itemRenderer.field_77023_b -= 150.0f;
    }

    public boolean isComplete() {
        long time = System.currentTimeMillis();
        return this.startTime + this.duration < time;
    }
}

