/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_OTHER = "O:";
    private static final String MARKER_STACK = "T:";
    private final File bookmarkFile;

    public BookmarkConfig(File jeiConfigurationDir) {
        this.bookmarkFile = new File(jeiConfigurationDir, "bookmarks.ini");
    }

    public void saveBookmarks(IIngredientManager ingredientManager, List<IIngredientListElement<?>> ingredientListElements) {
        ArrayList<String> strings = new ArrayList<String>();
        for (IIngredientListElement<?> element : ingredientListElements) {
            Object object = element.getIngredient();
            if (object instanceof ItemStack) {
                strings.add(MARKER_STACK + ((ItemStack)object).func_77955_b(new NBTTagCompound()).toString());
                continue;
            }
            strings.add(MARKER_OTHER + this.getUid(ingredientManager, element));
        }
        File file = this.bookmarkFile;
        try (FileWriter writer = new FileWriter(file);){
            IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save bookmarks list to file {}", (Object)file, (Object)e);
        }
    }

    public void loadBookmarks(IngredientManager ingredientManager, BookmarkList bookmarkList) {
        List ingredientJsonStrings;
        File file = this.bookmarkFile;
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            ingredientJsonStrings = IOUtils.readLines((Reader)reader);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load bookmarks from file {}", (Object)file, (Object)e);
            return;
        }
        ArrayList<IIngredientType> otherIngredientTypes = new ArrayList<IIngredientType>(ingredientManager.getRegisteredIngredientTypes());
        otherIngredientTypes.remove(VanillaTypes.ITEM);
        IIngredientHelper<ItemStack> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM);
        for (String ingredientJsonString : ingredientJsonStrings) {
            Object normalized;
            if (ingredientJsonString.startsWith(MARKER_STACK)) {
                String itemStackAsJson = ingredientJsonString.substring(MARKER_STACK.length());
                try {
                    NBTTagCompound itemStackAsNbt = JsonToNBT.func_180713_a((String)itemStackAsJson);
                    ItemStack itemStack = ItemStack.func_199557_a((NBTTagCompound)itemStackAsNbt);
                    if (!itemStack.func_190926_b()) {
                        normalized = itemStackHelper.normalizeIngredient(itemStack);
                        bookmarkList.addToLists(normalized, false);
                        continue;
                    }
                    LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
                }
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_OTHER)) {
                String uid = ingredientJsonString.substring(MARKER_OTHER.length());
                Object ingredient = this.getUnknownIngredientByUid(ingredientManager, otherIngredientTypes, uid);
                if (ingredient == null) continue;
                IIngredientHelper<Object> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
                normalized = ingredientHelper.normalizeIngredient(ingredient);
                bookmarkList.addToLists(normalized, false);
                continue;
            }
            LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
        }
        bookmarkList.notifyListenersOfChange();
    }

    private <T> String getUid(IIngredientManager ingredientManager, IIngredientListElement<T> element) {
        T ingredient = element.getIngredient();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
        return ingredientHelper.getUniqueId(ingredient);
    }

    @Nullable
    private Object getUnknownIngredientByUid(IngredientManager ingredientManager, Collection<IIngredientType> ingredientTypes, String uid) {
        for (IIngredientType ingredientType : ingredientTypes) {
            Object ingredient = ingredientManager.getIngredientByUid(ingredientType, uid);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }
}

