/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipe;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.recipes.InternalRecipeRegistryPlugin;
import mezz.jei.recipes.RecipeCategoryComparator;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ProgressManager;

public class RecipeRegistry
implements IRecipeRegistry {
    private final IIngredientRegistry ingredientRegistry;
    @Deprecated
    private final ImmutableList<IRecipeHandler> unsortedRecipeHandlers;
    private final ImmutableMultimap<String, IRecipeHandler> recipeHandlers;
    private final ImmutableList<IRecipeCategory> recipeCategories;
    private final Set<IRecipeCategory> emptyRecipeCategories = new HashSet<IRecipeCategory>();
    private final Set<IRecipeCategory> checkIfEmptyRecipeCategories = new HashSet<IRecipeCategory>();
    private final ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMultimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap;
    private final ImmutableListMultimap<IRecipeCategory, Object> recipeCatalysts;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final Map<Object, IRecipeWrapper> wrapperMap = new IdentityHashMap<Object, IRecipeWrapper>();
    private final ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories = ArrayListMultimap.create();
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final List<IRecipeRegistryPlugin> plugins = new ArrayList<IRecipeRegistryPlugin>();

    public RecipeRegistry(List<IRecipeCategory> recipeCategories, List<IRecipeHandler> unsortedRecipeHandlers, Multimap<String, IRecipeHandler> recipeHandlers, ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers, List<Object> unsortedRecipes, Multimap<String, Object> recipes, Multimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap, Multimap<String, Object> recipeCatalysts, IIngredientRegistry ingredientRegistry, List<IRecipeRegistryPlugin> plugins) {
        this.ingredientRegistry = ingredientRegistry;
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = recipeTransferHandlers;
        this.recipeHandlers = RecipeRegistry.buildRecipeHandlersMap(recipeHandlers);
        this.unsortedRecipeHandlers = RecipeRegistry.buildRecipeHandlersList(unsortedRecipeHandlers);
        this.recipeClickableAreasMap = ImmutableMultimap.copyOf(recipeClickableAreasMap);
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.addRecipes(unsortedRecipes, recipes);
        ImmutableListMultimap.Builder recipeCatalystsBuilder = ImmutableListMultimap.builder();
        ImmutableMultimap.Builder categoriesForRecipeCatalystKeysBuilder = ImmutableMultimap.builder();
        for (Map.Entry recipeCatalystEntry : recipeCatalysts.asMap().entrySet()) {
            String recipeCategoryUid = (String)recipeCatalystEntry.getKey();
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null) continue;
            Collection catalystIngredients = (Collection)recipeCatalystEntry.getValue();
            recipeCatalystsBuilder.putAll((Object)recipeCategory, (Iterable)catalystIngredients);
            for (Object catalystIngredient : catalystIngredients) {
                this.recipeInputMap.addRecipeCategory(recipeCategory, catalystIngredient);
                String catalystIngredientKey = this.getUniqueId(catalystIngredient);
                categoriesForRecipeCatalystKeysBuilder.put((Object)catalystIngredientKey, (Object)recipeCategoryUid);
            }
        }
        this.recipeCatalysts = recipeCatalystsBuilder.build();
        ImmutableMultimap categoriesForRecipeCatalystKeys = categoriesForRecipeCatalystKeysBuilder.build();
        InternalRecipeRegistryPlugin internalRecipeRegistryPlugin = new InternalRecipeRegistryPlugin(this, (ImmutableMultimap<String, String>)categoriesForRecipeCatalystKeys, ingredientRegistry, this.recipeCategoriesMap, this.recipeInputMap, this.recipeOutputMap, this.recipeWrappersForCategories);
        this.plugins.add(internalRecipeRegistryPlugin);
        this.plugins.addAll(plugins);
        for (IRecipeCategory recipeCategory : recipeCategories) {
            List recipeWrappers = this.getRecipeWrappers(recipeCategory);
            if (!recipeWrappers.isEmpty()) continue;
            this.emptyRecipeCategories.add(recipeCategory);
        }
        this.recipeCategories = ImmutableList.copyOf(recipeCategories);
    }

    private <T> String getUniqueId(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        return ingredientHelper.getUniqueId(ingredient);
    }

    private static ImmutableMap<String, IRecipeCategory> buildRecipeCategoriesMap(List<IRecipeCategory> recipeCategories) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            mapBuilder.put((Object)recipeCategory.getUid(), (Object)recipeCategory);
        }
        return mapBuilder.build();
    }

    private static ImmutableList<IRecipeHandler> buildRecipeHandlersList(List<IRecipeHandler> recipeHandlers) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        HashSet recipeHandlerClasses = new HashSet();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            Class recipeClass;
            if (recipeHandler == null) continue;
            try {
                recipeClass = recipeHandler.getRecipeClass();
            }
            catch (RuntimeException e) {
                Log.error("Recipe handler crashed.", e);
                continue;
            }
            catch (LinkageError e) {
                Log.error("Recipe handler crashed.", e);
                continue;
            }
            if (recipeHandlerClasses.contains(recipeClass)) {
                Log.error("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName(), new Object[0]);
                continue;
            }
            recipeHandlerClasses.add(recipeClass);
            listBuilder.add((Object)recipeHandler);
        }
        return listBuilder.build();
    }

    private static ImmutableMultimap<String, IRecipeHandler> buildRecipeHandlersMap(Multimap<String, IRecipeHandler> recipeHandlers) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ArrayListMultimap recipeHandlerClassesMap = ArrayListMultimap.create();
        for (Map.Entry entry : recipeHandlers.entries()) {
            IRecipeHandler recipeHandler = (IRecipeHandler)entry.getValue();
            Class recipeClass = recipeHandler.getRecipeClass();
            String recipeCategoryUid = (String)entry.getKey();
            Collection recipeHandlerClasses = recipeHandlerClassesMap.get((Object)recipeCategoryUid);
            if (!recipeHandlerClasses.contains(recipeClass)) {
                recipeHandlerClasses.add(recipeClass);
                builder.put(entry);
                continue;
            }
            Log.error("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName(), new Object[0]);
        }
        return builder.build();
    }

    private void addRecipes(List<Object> unsortedRecipes, Multimap<String, Object> recipes) {
        Collection entries = recipes.entries();
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Adding recipes", (int)(entries.size() + unsortedRecipes.size()));
        for (Map.Entry entry : entries) {
            progressBar.step("");
            String recipeCategoryUid = (String)entry.getKey();
            Object recipe = entry.getValue();
            this.addRecipe(recipe, recipeCategoryUid);
        }
        for (Object recipe : unsortedRecipes) {
            progressBar.step("");
            this.addRecipe(recipe);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        return new Focus<V>(mode, ingredient);
    }

    @Override
    public void addRecipe(Object recipe) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        this.addRecipe(recipe, recipe.getClass(), null);
    }

    @Override
    public void addRecipe(IRecipeWrapper recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        IRecipeCategory recipeCategory = this.getRecipeCategory(recipeCategoryUid);
        if (recipeCategory == null) {
            Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
            return;
        }
        this.addRecipe(recipe, recipe, recipeCategory);
    }

    private void addRecipe(Object recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        this.addRecipe(recipe, recipe.getClass(), recipeCategoryUid);
    }

    private <T> void addRecipe(T recipe, Class<? extends T> recipeClass, @Nullable String recipeCategoryUid) {
        IRecipeWrapper recipeWrapper;
        if (recipeCategoryUid == null) {
            IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass, null);
            if (recipeHandler != null) {
                recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
            } else {
                Log.error("Could not determine recipe category for recipe: {}", recipeClass);
                return;
            }
        }
        if ((recipeWrapper = this.getRecipeWrapper(recipe, recipeClass, recipeCategoryUid)) != null) {
            IRecipeCategory recipeCategory = this.getRecipeCategory(recipeCategoryUid);
            if (recipeCategory == null) {
                Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
                return;
            }
            this.addRecipe(recipe, recipeWrapper, recipeCategory);
        }
    }

    @Nullable
    private IRecipeCategory getRecipeCategory(String recipeCategoryUid) {
        return (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
    }

    private static <T> void logBrokenRecipeHandler(T recipe, IRecipeHandler<T> recipeHandler) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e2) {
            Log.error("Failed recipe.toString", e2);
            recipeInfoBuilder.append(recipe.getClass());
        }
        recipeInfoBuilder.append("\nRecipe Handler failed to create recipe wrapper\n");
        recipeInfoBuilder.append(recipeHandler.getClass());
        Log.error(recipeInfoBuilder.toString(), new Object[0]);
    }

    private <T> void addRecipe(T recipe, IRecipeWrapper recipeWrapper, IRecipeCategory recipeCategory) {
        try {
            this.addRecipeUnchecked(recipe, recipeWrapper, recipeCategory);
        }
        catch (BrokenCraftingRecipeException e) {
            Log.error("Found a broken crafting recipe.", e);
        }
        catch (RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromRecipe(recipe, recipeWrapper);
            Log.error("Found a broken recipe: {}\n", recipeInfo, e);
        }
        catch (LinkageError e) {
            String recipeInfo = ErrorUtil.getInfoFromRecipe(recipe, recipeWrapper);
            Log.error("Found a broken recipe: {}\n", recipeInfo, e);
        }
    }

    private <T> void addRecipeUnchecked(T recipe, IRecipeWrapper recipeWrapper, IRecipeCategory recipeCategory) {
        this.wrapperMap.put(recipe, recipeWrapper);
        Ingredients ingredients = this.getIngredients(recipeWrapper);
        this.recipeInputMap.addRecipe(recipeWrapper, recipeCategory, ingredients.getInputIngredients());
        this.recipeOutputMap.addRecipe(recipeWrapper, recipeCategory, ingredients.getOutputIngredients());
        this.recipeWrappersForCategories.put((Object)recipeCategory, (Object)recipeWrapper);
        if (this.emptyRecipeCategories.contains(recipeCategory)) {
            this.emptyRecipeCategories.remove(recipeCategory);
        }
    }

    public Ingredients getIngredients(IRecipeWrapper recipeWrapper) {
        Ingredients ingredients = new Ingredients();
        recipeWrapper.getIngredients(ingredients);
        return ingredients;
    }

    @Override
    @Deprecated
    public void removeRecipe(Object recipe) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        List<IRecipeHandler<?>> recipeHandlers1 = this.getRecipeHandlers(recipe.getClass());
        for (IRecipeHandler<?> recipeHandler : recipeHandlers1) {
            String recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
            this.removeRecipe(recipe, recipeCategoryUid);
        }
    }

    @Override
    public void removeRecipe(IRecipeWrapper recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        this.removeRecipe((Object)recipe, recipeCategoryUid);
    }

    private <T> void removeRecipe(T recipe, String recipeCategoryUid) {
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
            return;
        }
        try {
            this.removeRecipeUnchecked(recipe, recipeCategory);
        }
        catch (BrokenCraftingRecipeException e) {
            Log.error("Found a broken crafting recipe.", e);
        }
    }

    private <T> void removeRecipeUnchecked(T recipe, IRecipeCategory recipeCategory) {
        IRecipeWrapper recipeWrapper = this.getRecipeWrapper(recipe, recipeCategory.getUid());
        if (recipeWrapper != null) {
            Ingredients ingredients = this.getIngredients(recipeWrapper);
            this.recipeInputMap.removeRecipe(recipeWrapper, recipeCategory, ingredients.getInputIngredients());
            this.recipeOutputMap.removeRecipe(recipeWrapper, recipeCategory, ingredients.getOutputIngredients());
            this.recipeWrappersForCategories.remove((Object)recipeCategory, (Object)recipeWrapper);
            this.checkIfEmptyRecipeCategories.add(recipeCategory);
        }
    }

    @Override
    @Deprecated
    public void addSmeltingRecipe(List<ItemStack> inputs, ItemStack output) {
        ErrorUtil.checkNotEmpty(inputs, "inputs");
        ErrorUtil.checkNotEmpty(output, "output");
        SmeltingRecipe smeltingRecipe = new SmeltingRecipe(inputs, output);
        this.addRecipe(smeltingRecipe);
    }

    @Override
    @Deprecated
    public IRecipeWrapper createSmeltingRecipe(List<ItemStack> inputs, ItemStack output) {
        return Internal.getHelpers().getVanillaRecipeFactory().createSmeltingRecipe(inputs, output);
    }

    @Override
    @Deprecated
    public IRecipeWrapper createAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        return Internal.getHelpers().getVanillaRecipeFactory().createAnvilRecipe(leftInput, rightInputs, outputs);
    }

    @Override
    @Deprecated
    public IRecipeWrapper createBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput) {
        return Internal.getHelpers().getVanillaRecipeFactory().createBrewingRecipe(ingredients, potionInput, potionOutput);
    }

    @Override
    public List<IRecipeCategory> getRecipeCategories() {
        for (IRecipeCategory recipeCategory : this.checkIfEmptyRecipeCategories) {
            if (!this.getRecipeWrappers(recipeCategory).isEmpty()) continue;
            this.emptyRecipeCategories.add(recipeCategory);
        }
        this.checkIfEmptyRecipeCategories.clear();
        ArrayList<IRecipeCategory> recipeCategories = new ArrayList<IRecipeCategory>((Collection<IRecipeCategory>)this.recipeCategories);
        recipeCategories.removeAll(this.emptyRecipeCategories);
        return recipeCategories;
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories(List<String> recipeCategoryUids) {
        ErrorUtil.checkNotNull(recipeCategoryUids, "recipeCategoryUids");
        HashSet<String> uniqueUids = new HashSet<String>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String recipeCategoryUid : recipeCategoryUids) {
            if (uniqueUids.contains(recipeCategoryUid)) continue;
            uniqueUids.add(recipeCategoryUid);
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null || this.getRecipeWrappers(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Override
    @Deprecated
    @Nullable
    public <T> IRecipeHandler<T> getRecipeHandler(Class<? extends T> recipeClass) {
        return this.getRecipeHandler(recipeClass, null);
    }

    @Override
    @Nullable
    public IRecipeWrapper getRecipeWrapper(Object recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotEmpty(recipeCategoryUid, "recipeCategoryUid");
        return this.getRecipeWrapper(recipe, recipe.getClass(), recipeCategoryUid);
    }

    @Nullable
    private <T> IRecipeWrapper getRecipeWrapper(T recipe, Class<? extends T> recipeClass, String recipeCategoryUid) {
        if (this.wrapperMap.containsKey(recipe)) {
            return this.wrapperMap.get(recipe);
        }
        IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass, recipeCategoryUid);
        if (recipeHandler != null) {
            try {
                if (!recipeHandler.isRecipeValid(recipe)) {
                    return null;
                }
            }
            catch (RuntimeException e) {
                Log.error("Recipe check crashed", e);
                return null;
            }
            catch (LinkageError e) {
                Log.error("Recipe check crashed", e);
                return null;
            }
            try {
                IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
                this.wrapperMap.put(recipe, recipeWrapper);
                return recipeWrapper;
            }
            catch (RuntimeException e) {
                RecipeRegistry.logBrokenRecipeHandler(recipe, recipeHandler);
                return null;
            }
            catch (LinkageError e) {
                RecipeRegistry.logBrokenRecipeHandler(recipe, recipeHandler);
                return null;
            }
        }
        if (recipe instanceof IRecipeWrapper) {
            return (IRecipeWrapper)recipe;
        }
        return null;
    }

    @Nullable
    private <T> IRecipeHandler<T> getRecipeHandler(Class<? extends T> recipeClass, @Nullable String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ImmutableCollection recipeHandlers = recipeCategoryUid != null ? this.recipeHandlers.get((Object)recipeCategoryUid) : this.recipeHandlers.values();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        return null;
    }

    @Deprecated
    private <T> List<IRecipeHandler<T>> getRecipeHandlers(Class<? extends T> recipeClass) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ArrayList<IRecipeHandler<T>> recipeHandlers = new ArrayList<IRecipeHandler<T>>();
        ImmutableCollection allRecipeHandlers = this.recipeHandlers.values();
        for (IRecipeHandler recipeHandler : allRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        for (IRecipeHandler recipeHandler : allRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        return recipeHandlers;
    }

    @Nullable
    public RecipeClickableArea getRecipeClickableArea(GuiContainer gui, int mouseX, int mouseY) {
        ImmutableCollection recipeClickableAreas = this.recipeClickableAreasMap.get(gui.getClass());
        for (RecipeClickableArea recipeClickableArea : recipeClickableAreas) {
            if (!recipeClickableArea.checkHover(mouseX, mouseY)) continue;
            return recipeClickableArea;
        }
        return null;
    }

    public ImmutableCollection<RecipeClickableArea> getAllRecipeClickableAreas(GuiContainer gui) {
        return this.recipeClickableAreasMap.get(gui.getClass());
    }

    @Nullable
    private static FluidStack getFluidFromItemBlock(IFocus<?> focus) {
        Block block;
        Fluid fluid;
        ItemStack itemStack;
        Item item;
        Object ingredient = focus.getValue();
        if (ingredient instanceof ItemStack && (item = (itemStack = (ItemStack)ingredient).func_77973_b()) instanceof ItemBlock && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = ((ItemBlock)item).func_179223_d()))) != null) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    @Override
    public <V> List<IRecipeCategory> getRecipeCategories(IFocus<V> focus) {
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus = Focus.check(focus));
        if (fluidStack != null) {
            return this.getRecipeCategories(this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<String> allRecipeCategoryUids = new ArrayList<String>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<String> recipeCategoryUids = plugin.getRecipeCategoryUids(focus);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Category lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeCategoryUids.addAll(recipeCategoryUids);
        }
        return this.getRecipeCategories(allRecipeCategoryUids);
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        focus = Focus.check(focus);
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipeWrappers(recipeCategory, this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<T> recipeWrappers = plugin.getRecipeWrappers(recipeCategory, focus);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Wrapper lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeWrappers.addAll(recipeWrappers);
        }
        return allRecipeWrappers;
    }

    @Override
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<T> recipeWrappers = plugin.getRecipeWrappers(recipeCategory);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Wrapper lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeWrappers.addAll(recipeWrappers);
        }
        return allRecipeWrappers;
    }

    @Override
    public List<ItemStack> getCraftingItems(IRecipeCategory recipeCategory, @Nullable IFocus focus) {
        Object ingredient;
        if (focus != null) {
            focus = Focus.check(focus);
        }
        List<ItemStack> craftingItems = this.getCraftingItems(recipeCategory);
        if (focus != null && focus.getMode() == IFocus.Mode.INPUT && (ingredient = focus.getValue()) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            IIngredientHelper<ItemStack> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ItemStack.class);
            ItemStack matchingStack = ingredientHelper.getMatch(craftingItems, itemStack);
            if (matchingStack != null) {
                return Collections.singletonList(matchingStack);
            }
        }
        return craftingItems;
    }

    @Override
    public List<ItemStack> getCraftingItems(IRecipeCategory recipeCategory) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        List<Object> objects = this.getRecipeCatalysts(recipeCategory);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Object object : objects) {
            if (!(object instanceof ItemStack)) continue;
            itemStacks.add((ItemStack)object);
        }
        return Collections.unmodifiableList(itemStacks);
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory recipeCategory) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        return this.recipeCatalysts.get((Object)recipeCategory);
    }

    @Override
    @Nullable
    public IRecipeTransferHandler getRecipeTransferHandler(Container container, IRecipeCategory recipeCategory) {
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler recipeTransferHandler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)recipeCategory.getUid());
        if (recipeTransferHandler != null) {
            return recipeTransferHandler;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)"universal recipe transfer handler");
    }

    @Override
    public <T extends IRecipeWrapper> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipeWrapper, IFocus focus) {
        focus = Focus.check(focus);
        RecipeLayout recipeLayout = RecipeLayout.create(-1, recipeCategory, recipeWrapper, focus, 0, 0);
        Preconditions.checkNotNull((Object)recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout;
    }
}

