/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.Config;
import mezz.jei.util.FileUtil;
import mezz.jei.util.LegacyUtil;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;

public final class IngredientInformation {
    private static final String CACHE_FILE = "tooltipCache.zip";
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((String)"\\n");
    private static final Joiner NEWLINE_JOINER = Joiner.on((String)"\\n");
    private static final Object SAVE_LOCK = new Object();
    private static boolean needsSaving = false;
    private static boolean saving;
    private static final Map<String, List<String>> TOOLTIP_CACHE;
    @Nullable
    private static Language TOOLTIP_CACHE_LANG;

    private IngredientInformation() {
    }

    public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String displayName = ingredientHelper.getDisplayName(ingredient);
        return IngredientInformation.removeChatFormatting(displayName);
    }

    public static <T> List<String> getTooltipStrings(T ingredient, IIngredientHelper<T> ingredientHelper, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove) {
        String ingredientUid = ingredientHelper.getUniqueId(ingredient);
        List<String> tooltipStrings = TOOLTIP_CACHE.get(ingredientUid);
        if (tooltipStrings == null) {
            tooltipStrings = IngredientInformation.getTooltipStringsUncached(ingredient, ingredientRenderer, toRemove);
            TOOLTIP_CACHE.put(ingredientUid, tooltipStrings);
            IngredientInformation.markDirty();
        }
        return tooltipStrings;
    }

    private static <T> List<String> getTooltipStringsUncached(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> excludeWords) {
        List<String> tooltip = LegacyUtil.getTooltip(ingredientRenderer, Minecraft.func_71410_x(), ingredient, Config.getSearchAdvancedTooltips());
        ArrayList<String> cleanTooltip = new ArrayList<String>(tooltip.size());
        for (String line : tooltip) {
            line = IngredientInformation.removeChatFormatting(line);
            line = Translator.toLowercaseWithLocale(line);
            for (String excludeWord : excludeWords) {
                line = line.replace(excludeWord, "");
            }
            if (StringUtils.func_151246_b((String)line)) continue;
            cleanTooltip.add(line);
        }
        return cleanTooltip;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = TextFormatting.func_110646_a((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    public static <V> Collection<String> getColorStrings(V ingredient, IIngredientHelper<V> ingredientHelper) {
        Iterable<Color> colors = ingredientHelper.getColors(ingredient);
        ColorNamer colorNamer = Internal.getColorNamer();
        return colorNamer.getColorNames(colors, true);
    }

    public static void onResourceReload() {
        Minecraft minecraft = Minecraft.func_71410_x();
        Language currentLanguage = minecraft.func_135016_M().func_135041_c();
        if (!currentLanguage.equals((Object)TOOLTIP_CACHE_LANG)) {
            IngredientInformation.saveTooltipCacheSync(TOOLTIP_CACHE, TOOLTIP_CACHE_LANG);
            TOOLTIP_CACHE.clear();
            TOOLTIP_CACHE_LANG = currentLanguage;
            IngredientInformation.loadTooltipCache(currentLanguage);
        }
    }

    private static void loadTooltipCache(Language language) {
        File tooltipFile = new File(Config.getJeiConfigurationDir(), CACHE_FILE);
        String languageCode = language.func_135034_a();
        String zipEntryName = "tooltipCache_" + languageCode + ".txt";
        FileUtil.readZipFileSafely(tooltipFile, zipEntryName, new FileUtil.ZipInputFileOperation(){

            @Override
            public void handle(ZipInputStream zipInputStream) throws IOException {
                String tooltip;
                String ingredientUid;
                BufferedReader reader = new BufferedReader(new InputStreamReader(zipInputStream));
                while ((ingredientUid = reader.readLine()) != null && (tooltip = reader.readLine()) != null) {
                    List tooltipLines = NEWLINE_SPLITTER.splitToList((CharSequence)tooltip);
                    TOOLTIP_CACHE.put(ingredientUid, tooltipLines);
                }
                reader.close();
            }
        });
    }

    public static void markDirty() {
        needsSaving = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onClientTick() {
        if (Minecraft.func_71410_x().field_71441_e.func_72820_D() % 1200L == 0L && needsSaving) {
            Object object = SAVE_LOCK;
            synchronized (object) {
                if (needsSaving && !saving) {
                    needsSaving = false;
                    saving = true;
                    IngredientInformation.saveTooltipCacheASync();
                }
            }
        }
    }

    private static void saveTooltipCacheASync() {
        if (TOOLTIP_CACHE.isEmpty() || TOOLTIP_CACHE_LANG == null) {
            return;
        }
        final HashMap<String, List<String>> tooltipCache = new HashMap<String, List<String>>(TOOLTIP_CACHE);
        final Language tooltipCacheLang = TOOLTIP_CACHE_LANG;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IngredientInformation.saveTooltipCacheSync(tooltipCache, tooltipCacheLang);
                Object object = SAVE_LOCK;
                synchronized (object) {
                    saving = false;
                }
            }
        }).start();
    }

    private static void saveTooltipCacheSync(final Map<String, List<String>> tooltipCache, @Nullable Language tooltipCacheLang) {
        if (tooltipCache.isEmpty() || tooltipCacheLang == null) {
            return;
        }
        File file = new File(Config.getJeiConfigurationDir(), CACHE_FILE);
        String languageCode = tooltipCacheLang.func_135034_a();
        String zipEntryName = "tooltipCache_" + languageCode + ".txt";
        boolean write = FileUtil.writeZipFileSafely(file, zipEntryName, new FileUtil.ZipOutputFileOperation(){

            @Override
            public void handle(ZipOutputStream zipOutputStream) throws IOException {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
                for (Map.Entry entry : tooltipCache.entrySet()) {
                    String ingredientUid = (String)entry.getKey();
                    List tooltipLines = (List)entry.getValue();
                    String tooltip = NEWLINE_JOINER.join((Iterable)tooltipLines);
                    writer.write(ingredientUid);
                    writer.newLine();
                    writer.write(tooltip);
                    writer.newLine();
                }
            }
        });
        if (write) {
            Log.info("Saved tooltip cache to {}.", file.getAbsoluteFile());
        }
    }

    static {
        TOOLTIP_CACHE = new HashMap<String, List<String>>();
    }
}

