/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling;

import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModCritical;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;

public class LevelingActiveToolMod
extends ActiveToolMod {
    static List<Material> materialBlacklist = Arrays.asList(Material.leaves, Material.vine, Material.circuits, Material.glass, Material.piston, Material.snow);

    public boolean beforeBlockBreak(ToolCore tool, ItemStack stack, int x, int y, int z, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return false;
        }
        if (!(tool instanceof HarvestTool)) {
            return false;
        }
        Block block = entity.worldObj.getBlock(x, y, z);
        int meta = entity.worldObj.getBlockMetadata(x, y, z);
        if (block == null || materialBlacklist.contains(block.getMaterial())) {
            return false;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        HarvestTool harvestTool = (HarvestTool)tool;
        boolean harvestable = false;
        boolean effective = false;
        boolean strong = false;
        harvestable = harvestTool.canHarvestBlock(block, stack);
        Float strength = Float.valueOf(harvestTool.calculateStrength(tags, block, meta));
        strong = strength.floatValue() >= 1.0f;
        effective = harvestTool.isEffective(block.getMaterial());
        boolean blockIsOre = false;
        ItemStack blockStack = new ItemStack(Item.getItemFromBlock((Block)block), 1, meta);
        for (int id : OreDictionary.getOreIDs((ItemStack)blockStack)) {
            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
            blockIsOre = true;
            break;
        }
        if (harvestable && effective && strong) {
            int xp = 1;
            if (blockIsOre) {
                ++xp;
            }
            LevelingLogic.addXP(stack, (EntityPlayer)entity, xp);
            if (block.quantityDropped(IguanaTweaksTConstruct.random) > 1) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LAPIS, 1, tags);
            } else {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.REDSTONE, 1, tags);
            }
            boolean itsHotInHere = false;
            itsHotInHere |= entity.worldObj.getBlock(x + 1, y, z).getMaterial() == Material.lava;
            itsHotInHere |= entity.worldObj.getBlock(x - 1, y, z).getMaterial() == Material.lava;
            itsHotInHere |= entity.worldObj.getBlock(x, y + 1, z).getMaterial() == Material.lava;
            itsHotInHere |= entity.worldObj.getBlock(x, y - 1, z).getMaterial() == Material.lava;
            itsHotInHere |= entity.worldObj.getBlock(x, y, z + 1).getMaterial() == Material.lava;
            if (itsHotInHere |= entity.worldObj.getBlock(x, y, z - 1).getMaterial() == Material.lava) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.AUTOSMELT, 10, tags);
            }
        }
        return false;
    }

    public boolean doesCriticalHit(ToolCore tool, NBTTagCompound tags, NBTTagCompound toolTags, ItemStack stack, EntityLivingBase player, Entity entity) {
        if (toolTags.hasKey(ModCritical.modCritical.key)) {
            return IguanaTweaksTConstruct.random.nextInt(10) == 0;
        }
        return false;
    }
}

